
local ae = require "apolloengine"
local mf = require "mathfunction"

local obj = {}

obj.renderObject = nil
obj.queue = 100

function obj:Initialize(host, size)
        
  self.Threshold = mf.vector1(128.0);
  
  self.renderObject = host:CreateRenderObject("comm:documents/shaders/posteffect/threshold.material");
  
  host:RegisterScriptParameter(self, "Threshold");
  
  return self.queue
end

function obj:Resizeview(size)
end

function obj:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget()
  Output:ClearBuffer(ae.RenderTargetEntity.CF_COLOR)

  local materials = self.renderObject.MaterialEntities;
  local material = materials[1];
    
  material:SetParameter(
          "_MainTex",
          Scene:GetAttachment(ae.RenderTargetEntity.TA_COLOR_0));
  
  material:SetParameter("_Threshold", mf.vector1(math.max(math.min(self.Threshold:x() / 255.0,1.0),0.0)) );
  
  self.renderObject:Draw(pipeline)
end


return obj;