require "utility"
local ae = require "apolloengine"
local vc = require "venuscore"
local mf = require "mathfunction"

local obj = {}


function obj:Initialize(host, size)

    self.order = 100

    self.TEXTURE_MASKING = ae.IMaterialSystem:NewParameterSlot(
            ae.ShaderEntity.UNIFORM,
            "TEXTURE_MASKING");

    self.renderObject = host:CreateRenderObject("comm:documents/material/masking.material")

    self:_InitializeParameters()

    self:_UpdateParameters()

    return self.order
end

function obj:Resizeview(size)
end

function obj:Process(pipeline, Original, Scene, Output)

    self:_UpdateParameters()

    local colorClear = ae.RenderTargetEntity.CF_COLOR
    local color0 = ae.RenderTargetEntity.TA_COLOR_0

    self.renderObject:SetParameter(
            ae.ShaderEntity.TEXTURE_DIFFUSE,
            Scene:GetAttachment(color0))

    Output:PushRenderTarget()
    Output:ClearBuffer(colorClear)
    self.renderObject:Draw(pipeline)
end

local function _CreateEmptyTexture()
    local tex = ae.TextureEntity()
    tex:PushMetadata(ae.TextureBufferMetadata(mf.vector2(4, 4)))
    tex:SetJobType(vc.IJob.JT_SYNCHRONOUS)
    tex:CreateResource()
    return tex
end

function obj:_InitializeParameters()

    self.maskingTexture = _CreateEmptyTexture()
    self.lastMaskingTexture = nil

end

function obj:_UpdateParameters()

    if self.lastMaskingTexture ~= self.maskingTexture then

        self.renderObject:SetParameter(
                self.TEXTURE_MASKING,
                self.maskingTexture)

        self.lastMaskingTexture = self.maskingTexture
    end
end

return obj