
local ae = require "apolloengine"
local mf = require "mathfunction"

local obj = {}

obj.renderObject = nil
obj.queue = 100

function obj:Initialize(host, size)
 
  self.IMAGE_SIZE = ae.IMaterialSystem:NewParameterSlot(
          ae.ShaderEntity.UNIFORM,
          "ImageSize")

  self.renderObject = host:CreateRenderObject("comm:documents/shaders/posteffect/findedge.material");
  
  self.renderObject:SetParameter(self.IMAGE_SIZE, size);
  
  return self.queue
end

function obj:Resizeview(size)
  self.renderObject:SetParameter(self.IMAGE_SIZE, size);
end

function obj:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget()
  Output:ClearBuffer(ae.RenderTargetEntity.CF_COLOR)

  local materials = self.renderObject.MaterialEntities;
  local material = materials[1];
    
  material:SetParameter(
          "_MainTex",
          Scene:GetAttachment(ae.RenderTargetEntity.TA_COLOR_0));
  
  self.renderObject:Draw(pipeline)
end


return obj;