local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local DirectionalBlur = {}
DirectionalBlur.Do = 0;
DirectionalBlur.Queue = 310;
DirectionalBlur.angle = 0;
DirectionalBlur.blur_length = 10;
DirectionalBlur.stepsize = 1;

function DirectionalBlur:Initialize(host, size)
  self.BlUR_LENGTH = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "BlUR_LENGTH");
    
  self.ANGLE = apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,
    "ANGLE");
  
  local pathout = venuscore.IFileSystem:PathAssembly("comm:documents/material/directionalblur.material");
  self.Do = host:CreateRenderObject(pathout);
  self.ratio = self:GetRatio(size);
  self.Do:SetParameter(self.BlUR_LENGTH,mathfunction.vector1(math.floor(math.abs(DirectionalBlur.blur_length))));
  self.Do:SetParameter(self.ANGLE,mathfunction.vector2(-math.cos(DirectionalBlur.angle/180.0 * math.pi),
          math.sin(DirectionalBlur.angle/180.0 * math.pi) * self.ratio)* DirectionalBlur.stepsize/1000);
  
  host:RegisterScriptParameter(self,"angle");
  host:RegisterScriptParameter(self,"blur_length");
  host:RegisterScriptParameter(self,"stepsize");
  return self.Queue;
end



function DirectionalBlur:Resizeview(size)
  self.ratio = self:GetRatio(size);
  self.Do:SetParameter(self.BlUR_LENGTH,mathfunction.vector1(math.floor(math.abs(DirectionalBlur.blur_length))));
  self.Do:SetParameter(self.ANGLE,mathfunction.vector2(-math.cos(DirectionalBlur.angle/180.0 * math.pi),
          math.sin(DirectionalBlur.angle/180.0 * math.pi) * self.ratio)* DirectionalBlur.stepsize/1000);
end

function DirectionalBlur:GetRatio(size)
  local ratio = 1;
  if size:y() ~= 0 then
    ratio = size:x()/size:y();
  end
  return ratio;
end

function DirectionalBlur:Process(pipeline, Original, Scene, Output)
  self.Do:SetParameter(self.BlUR_LENGTH,mathfunction.vector1(math.floor(math.abs(DirectionalBlur.blur_length))));
  self.Do:SetParameter(self.ANGLE,mathfunction.vector2(-math.cos(DirectionalBlur.angle/180.0 * math.pi),
          math.sin(DirectionalBlur.angle/180.0 * math.pi) * self.ratio)* DirectionalBlur.stepsize/1000);
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Do:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.Do:Draw(pipeline);
end

return DirectionalBlur;