
local ae = require "apolloengine"
local mf = require "mathfunction"

local obj = {}

obj.renderObject = nil
obj.queue = 100

function obj:Initialize(host, size)
 
  --self.SCALE_PARAM_SLOT = ae.IMaterialSystem:NewParameterSlot(ae.ShaderEntity.UNIFORM,"Scale")
        
  self.Size = mf.vector1(0.1);
  self.Convergence = mf.vector1(100.0);
  self.Center = mf.vector2(0.5, 0.5);
  self.fboSize = mf.vector2(size:x(), size:y());
  
  
  self.renderObject = host:CreateRenderObject("comm:documents/shaders/posteffect/cclens.material");
  
  host:RegisterScriptParameter(self, "Center");
  host:RegisterScriptParameter(self, "Size"); --[0,500]
  host:RegisterScriptParameter(self, "Convergence"); --[-200,100]
  
  return self.queue
end

function obj:Resizeview(size)
  self.fboSize = mf.vector2(size:x(), size:y());
end

function obj:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget()
  Output:ClearBuffer(ae.RenderTargetEntity.CF_COLOR)

  local materials = self.renderObject.MaterialEntities;
  local material = materials[1];
    
  material:SetParameter(
          "_MainTex",
          Scene:GetAttachment(ae.RenderTargetEntity.TA_COLOR_0));
  
  local radius = math.max(self.Size:x(), 0.00001);
  material:SetParameter("_Radius", mf.vector2(radius, radius * self.fboSize:x() / self.fboSize:y()));

  
  material:SetParameter("_Convergence", self.Convergence * (-0.01) );
  material:SetParameter("_DistortCenter", self.Center );
  
  self.renderObject:Draw(pipeline)
end


return obj;