require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"
local venuscore = require "venuscore"
local screen = {}

screen.renderObject = nil;
screen.queue = 101;
screen.blendtex = nil;

function screen:Initialize(host, size)
  local preTexPath = "comm:documents/texture/posteffect/lutpv.png";
  self.blendtex = apolloengine.TextureEntity();
  self.blendtex:PushMetadata(apolloengine.TextureFileMetadata(
        apolloengine.TextureEntity.TU_STATIC,
        apolloengine.TextureEntity.PF_AUTO,1, false,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TF_NEAREST,
        apolloengine.TextureEntity.TF_NEAREST,
        preTexPath));
  self.blendtex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
  self.blendtex:CreateResource();
  self.TEXTURE_BLEND = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"TEXTURE_BLEND");
  self.renderObject = host:CreateRenderObject("comm:documents/material/blend_screen.material");
  host:RegisterScriptParameter(self,"blendtex");
  return self.queue;
end

function screen:Resizeview(size)

end

function screen:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
  self.renderObject:SetParameter(
          apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
          Scene:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));
        
  self:UpdateParameters();
  
  self.renderObject:Draw(pipeline);
end

function screen:UpdateParameters()
  if self.blendtex ~= nil then
    self.renderObject:SetParameter(self.TEXTURE_BLEND, self.blendtex);
  else
    LOG("****self.blendtex is nil***");
  end
end

return screen;