require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"

local blackcircles = {}

blackcircles.renderObject = nil;
blackcircles.queue = 100;
blackcircles.eyesmask = nil;
blackcircles.strengh = 0.5;

function blackcircles:Initialize(host, size)
  self.Stepsize1 = mathfunction.vector2(3,3);
  self.Stepsize2 = mathfunction.vector2(7,7);
  
  self.GAUSSIAN_STEP = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "GAUSSIAN_STEP");
  self.GAUSSUAN_COORDNATE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.INTERNAL,
      "GAUSSUAN_COORDNATE");
  
  self.TEXTURE_EYEMASK = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_EYEMASK");
  self.TEXTURE_ORIGIN = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_ORIGIN");
  self.UNIFORM_STRENGTH = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_STRENGTH");



  local GuassStep1 = self.Stepsize1 / size;
  self.GaussXY = host:CreateRenderObject( "docs:beauty/material/gaussianblurbeauty.material" );
  self.GaussXY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep1:x(), GuassStep1:y()) );

  local GuassStep2 = self.Stepsize2 / size;
  self.GaussXY2 = host:CreateRenderObject( "docs:beauty/material/gaussianblurbeauty.material" );
  self.GaussXY2:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep2:x(), GuassStep2:y()) );
  
  
  self.Blend = host:CreateRenderObject( "docs:beauty/material/blackeyescircles.material" );
  self.Blend:SetParameter( self.UNIFORM_STRENGTH, mathfunction.vector1(self.strengh) );

  self.blurRT1 = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_A, size );
  self.blurRT2 = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_B, size );

  return self.queue;
end

function blackcircles:Resizeview(size)
  local GuassStep1 = self.Stepsize1 / size;
  local GuassStep2 = self.Stepsize2 / size;
  --local GuassStep2 = self.Stepsize2 / size;
  --self.Stepsize2 = mathfunction.vector2(2, 2);
  self.size = size;
  self.GaussXY:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep1:x(), GuassStep1:y()) );
  self.GaussXY2:SetParameter( self.GAUSSIAN_STEP, mathfunction.vector2( GuassStep2:x(), GuassStep2:y()) );

end

function blackcircles:Process(pipeline, Original, Scene, Output)
  
  self:_UpdateParameters();
  local origintexture =  Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 )
  

  
  self.blurRT1:PushRenderTarget();
  self.blurRT1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.GaussXY:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    origintexture);
  self.GaussXY:Draw(pipeline); --高斯模糊1



  self.blurRT2:PushRenderTarget();
  self.blurRT2:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.GaussXY2:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
   self.blurRT1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
  self.GaussXY2:Draw(pipeline); --高斯模糊2

  
  Output:PushRenderTarget();
  Output:ClearBuffer(apolloengine.RenderTargetEntity.TA_COLOR_0);
  self.Blend:SetParameter(self.TEXTURE_ORIGIN,origintexture);
  self.Blend:SetParameter(self.TEXTURE_EYEMASK,self.eyesmask);
  self.Blend:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_SPECULAR,
    self.blurRT2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
  self.Blend:Draw(pipeline);
  
end

function blackcircles:_UpdateParameters()
  self.Blend:SetParameter( self.UNIFORM_STRENGTH, mathfunction.vector1(self.strengh) );
end

return blackcircles;