local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

require "utility"

local bloomEffect = {}
bloomEffect.Rt = 0;
bloomEffect.Rt1 = 0;
bloomEffect.Rt2 = 0;
bloomEffect.Rt3 = 0;

bloomEffect.bluraround = 0;
bloomEffect.bluraroundT = 0;
bloomEffect.blurHorizon = 0;
bloomEffect.blurVertical = 0;

bloomEffect.blurradius = 0;
bloomEffect.bloomparam = 0;
bloomEffect.gamma = 0;
bloomEffect.bloomthreshold = 0;
bloomEffect.maxluminance = 0;
bloomEffect.Queue = 100;

function bloomEffect:Initialize(host, size)

  self.fbosize = mathfunction.vector2(size:x(), size:y());

  self.AROUND_COORDNATE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "AROUND_COORDNATE");
  self.TEXELSIZE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXELSIZE");
  self.BLOOM_THRESHOLD = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "BLOOM_THRESHOLD");
  self.BLUR_RADIUS = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "BLUR_RADIUS");

  self.TEXTURE_BLUR1 = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_BLUR1");
  self.TEXTURE_BLUR2 = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_BLUR2");
  self.TEXTURE_BLUR3 = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_BLUR3");

  self.TEXTURE_BLOOM = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_BLOOM");
  self.TEXTURE_CURVE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_CURVE");
  self.BLOOM_PARAM = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "BLOOM_PARAM");
  self.GAMMA = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "GAMMA");
  self.MAXLUMINANCE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "MAXLUMINANCE");

	self.bluraround = host:CreateRenderObject( "comm:documents/superme_bloom/superme_blur.material" );
  self.bluraroundT = host:CreateRenderObject( "comm:documents/superme_bloom/superme_blurT.material" );
  self.blurHorizon = host:CreateRenderObject( "comm:documents/superme_bloom/superme_blurH.material" );
  self.blurVertical = host:CreateRenderObject( "comm:documents/superme_bloom/superme_blurV.material" );

  self.bloomcombine = host:CreateRenderObject( "comm:documents/superme_bloom/superme_bloomcombine.material");
  self.finalbloom = host:CreateRenderObject( "comm:documents/superme_bloom/superme_bloom.material");


  --self.blit = host:CreateRenderObject( "comm:documents/material/blit.material");


  self.maxluminance = mathfunction.vector2(0.998, 1.002);
  self.blurradius = mathfunction.vector2(0.83, 1.481);
  self.bloomparam = mathfunction.vector1(3.0);
  self.bloomthreshold = mathfunction.vector1(0.83);
  self.gamma = mathfunction.vector1(0.667);

  --[[self.curveTex = apolloengine.TextureEntity();
  self.curveTex:PushMetadata(apolloengine.TextureFileMetadata(
        apolloengine.TextureEntity.TU_STATIC,
        apolloengine.TextureEntity.PF_AUTO,1, false,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TF_NEAREST,
        apolloengine.TextureEntity.TF_NEAREST,
        "docs:superme3d/dollmaterial/Curvetex.png"));
  self.curveTex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
  self.curveTex:CreateResource();]]--

	self.Rt = host:CreateRenderTarget(
    apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      self.fbosize,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      0));

  local scale = 1.0 / 4.0
  self.Rt1 = host:CreateRenderTarget(
    apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        mathfunction.vector4(self.fbosize:x()*scale,self.fbosize:y()*scale,0,0),
        self.fbosize*scale,
        mathfunction.vector2(scale,scale)),
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      self.fbosize*scale,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      0));

  self.Rt1_a = host:CreateRenderTarget(
    apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        mathfunction.vector4(self.fbosize:x()*scale,self.fbosize:y()*scale,0,0),
        self.fbosize*scale,
        mathfunction.vector2(scale,scale)),
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      self.fbosize*scale,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      0));
 -- self.Rt1_a:SetResizeviewFlag(false);

  scale = 1.0 / 8.0

  self.Rt2 = host:CreateRenderTarget(
    apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        mathfunction.vector4(self.fbosize:x()*scale,self.fbosize:y()*scale,0,0),
        self.fbosize*scale,
        mathfunction.vector2(scale,scale)),
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      self.fbosize*scale,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      0));
 -- self.Rt2:SetResizeviewFlag(false);
  self.Rt2_a = host:CreateRenderTarget(
    apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        mathfunction.vector4(self.fbosize:x()*scale,self.fbosize:y()*scale,0,0),
        self.fbosize*scale,
        mathfunction.vector2(scale,scale)),
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      self.fbosize*scale,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      0));
  --self.Rt2_a:SetResizeviewFlag(false);

  scale = 1.0 / 16.0

  self.Rt3 = host:CreateRenderTarget(
    apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        mathfunction.vector4(self.fbosize:x()*scale,self.fbosize:y()*scale,0,0),
        self.fbosize*scale,
        mathfunction.vector2(scale,scale)),
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      self.fbosize*scale,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      0));
  --self.Rt3:SetResizeviewFlag(false);
  self.Rt3_a = host:CreateRenderTarget(
    apolloengine.RenderTargetMetadata(
        apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
        mathfunction.vector4(self.fbosize:x()*scale,self.fbosize:y()*scale,0,0),
        self.fbosize*scale,
        mathfunction.vector2(scale,scale)),
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      self.fbosize*scale,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TW_MIRRORED_REPEAT,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      0));
  --self.Rt3_a:SetResizeviewFlag(false);
  host:RegisterScriptParameter(self,"blurradius");
  host:RegisterScriptParameter(self,"bloomparam");
  --host:RegisterScriptParameter(self,"gamma");
  host:RegisterScriptParameter(self,"bloomthreshold");
  --host:RegisterScriptParameter(self,"maxluminance");
  return self.Queue;
end

function bloomEffect:Resizeview(size)
  self.fbosize = mathfunction.vector2(size:x(), size:y());
end

function bloomEffect:Process(pipeline, Original, Scene, Output)

  local layerDepth = 2.0;

  self.Rt1:PushRenderTarget();
  self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.bluraroundT:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.bluraroundT:SetParameter( self.BLOOM_THRESHOLD, self.bloomthreshold );
  self.bluraroundT:SetParameter( self.TEXELSIZE, mathfunction.vector2( 1.0 / self.fbosize:x(), 1.0 / self.fbosize:y() ) );
  self.bluraroundT:Draw(pipeline);

  self.Rt1_a:PushRenderTarget();
  self.Rt1_a:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.blurHorizon:SetParameter(
    self.BLUR_RADIUS, self.blurradius);
  self.blurHorizon:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.blurHorizon:SetParameter( self.TEXELSIZE, mathfunction.vector2(4.0 / self.fbosize:x(), 4.0 / self.fbosize:y() ) );
  self.blurHorizon:Draw(pipeline);

  self.Rt1:PushRenderTarget();
  self.Rt1:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.blurVertical:SetParameter(
    self.BLUR_RADIUS, self.blurradius);
  self.blurVertical:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt1_a:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.blurVertical:SetParameter( self.TEXELSIZE, mathfunction.vector2(4.0 / self.fbosize:x(), 4.0 / self.fbosize:y() ) );
  self.blurVertical:Draw(pipeline);

  layerDepth = 4.0;
  self.Rt2:PushRenderTarget();
  self.Rt2:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.bluraround:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.bluraround:SetParameter( self.TEXELSIZE, mathfunction.vector2(4.0 / self.fbosize:x(), 4.0 / self.fbosize:y() ) );
  self.bluraround:Draw(pipeline);

  self.Rt2_a:PushRenderTarget();
  self.Rt2_a:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.blurHorizon:SetParameter(
    self.BLUR_RADIUS, self.blurradius);
  self.blurHorizon:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.blurHorizon:SetParameter( self.TEXELSIZE, mathfunction.vector2(8.0 / self.fbosize:x(), 8.0 / self.fbosize:y() ) );
  self.blurHorizon:Draw(pipeline);

  self.Rt2:PushRenderTarget();
  self.Rt2:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.blurVertical:SetParameter(
    self.BLUR_RADIUS, self.blurradius);
  self.blurVertical:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt2_a:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.blurVertical:SetParameter( self.TEXELSIZE, mathfunction.vector2(8.0 / self.fbosize:x(), 8.0 / self.fbosize:y() ) );
  self.blurVertical:Draw(pipeline);


  layerDepth = 8.0;
  self.Rt3:PushRenderTarget();
  self.Rt3:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.bluraround:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.bluraround:SetParameter( self.TEXELSIZE, mathfunction.vector2(8.0 / self.fbosize:x(), 8.0 / self.fbosize:y() ) );
  self.bluraround:Draw(pipeline);

  self.Rt3_a:PushRenderTarget();
  self.Rt3_a:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.blurHorizon:SetParameter(
    self.BLUR_RADIUS, self.blurradius);
  self.blurHorizon:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt3:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.blurHorizon:SetParameter( self.TEXELSIZE, mathfunction.vector2(16.0 / self.fbosize:x(), 16.0 / self.fbosize:y() ) );
  self.blurHorizon:Draw(pipeline);

  self.Rt3:PushRenderTarget();
  self.Rt3:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.blurVertical:SetParameter(
    self.BLUR_RADIUS, self.blurradius);
  self.blurVertical:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt3_a:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.blurVertical:SetParameter( self.TEXELSIZE, mathfunction.vector2(16.0 / self.fbosize:x(), 16.0 / self.fbosize:y() ) );
  self.blurVertical:Draw(pipeline);

  self.Rt:PushRenderTarget();
  self.Rt:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.bloomcombine:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.bloomcombine:SetParameter( self.TEXTURE_BLUR1,
    self.Rt1:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.bloomcombine:SetParameter( self.TEXTURE_BLUR2,
    self.Rt2:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.bloomcombine:SetParameter( self.TEXTURE_BLUR3,
    self.Rt3:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.bloomcombine:Draw(pipeline);

  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.finalbloom:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.finalbloom:SetParameter(
    self.TEXTURE_BLOOM,
    self.Rt:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.finalbloom:SetParameter(
    self.BLOOM_PARAM, self.bloomparam );
  self.finalbloom:SetParameter(
    self.GAMMA, self.gamma );
  self.finalbloom:SetParameter(
    self.MAXLUMINANCE, self.maxluminance );
  self.finalbloom:Draw(pipeline);
end

return bloomEffect;
