local GenericNode = require "apolloengine.nodes.genericnode"
local mathfunction = require "mathfunction"
local apollocore = require "apollocore"
local venuscore = require "venuscore"




--初始化内部用到的shader slot
apollocore.IMaterialSystem:NewParameterSlot(apollocore.ShaderEntity.INTERNAL,"COLOR_ALPHA");
apollocore.IMaterialSystem:NewParameterSlot(apollocore.ShaderEntity.INTERNAL,"EMITTER_AGE");
apollocore.IMaterialSystem:NewParameterSlot(apollocore.ShaderEntity.INTERNAL,"PARTICLE_COLOR");
apollocore.IMaterialSystem:NewParameterSlot(apollocore.ShaderEntity.INTERNAL,"PARTICLE_OFFEET");
apollocore.IMaterialSystem:NewParameterSlot(apollocore.ShaderEntity.INTERNAL,"PARTICLE_SPEED");
apollocore.IMaterialSystem:NewParameterSlot(apollocore.ShaderEntity.INTERNAL,"PARTICLE_STRETCH");
local globaloffsetslot = apollocore.IMaterialSystem:NewParameterSlot(apollocore.ShaderEntity.UNIFORM,"PARTICLE_GLOBAL_OFFSET");
local globalscaleslot = apollocore.IMaterialSystem:NewParameterSlot(apollocore.ShaderEntity.UNIFORM, "PARTICLE_GLOBAL_SCALE");
local globalrotationslot = apollocore.IMaterialSystem:NewParameterSlot(apollocore.ShaderEntity.UNIFORM,"PARTICLE_GLOBAL_ROTATION_MATRIX");

local ParticleNode =  venuscore.ActorNode:extend("ParticleNode");

--affector的实例化要自己做
venuscore.BundleSystem:OnDeserialize(apollocore.CPUEmitter:GetTypeName(),
        function(cls,attributes)
          for name, attr in pairs(attributes) do
              if name == "Layer" then
                local layer = venuscore.Utility:ConvertStringToUInt64(attr);
                cls[name] = layer;
              else
                cls[name] = attr;
              end
          end
        end
)
venuscore.BundleSystem:OnDeserialize(ParticleNode:GetTypeName(),
  function(cls,attributes,nodes)
    if cls then
      for name,attr in pairs(attributes) do
        if string.find(name,'ChildNodes') then
          for k, v in pairs(attr) do
            cls:AttachNode(v);
          end 
        end
      end
      table.insert(nodes,cls);
    end
  end)


ParticleNode:MemberRegister("node");

function ParticleNode:new(scene)
  --ParticleNode.super.new(self);
  self.AffectorList = {};  --保存所有的affector
  self.CurveList = {}; --保存所有的曲线
  --self.UserscriptList = {};
  self.ScriptComponents = {}; --用来保存脚本component对象
  self:Initialize(scene);
end

function ParticleNode:Initialize(scene)

  self:CreateEmitter(scene); --创建粒子发射器
  self:CreateAffector(); --创建affectors
  self:CreateCurve();    --创建曲线
  self.node:Initialize();
  
  
  self:SetGravity(mathfunction.vector3(0.0,0.0,0.0)); --重力参数
end

function ParticleNode:CreateResource()
  self:CreateMaterial(); --创建材质
  self.node:CreateResource();
  self:SetGlobalParameter(); 
end


function ParticleNode:GetNativeNode()
  return self.node;
end

function ParticleNode:GetName()
  return self.node:GetName();
end

function ParticleNode:SetName(name)
  self.node:SetName(name);
end


function ParticleNode:CreateEmitter(scene)
  if scene then
    self.node = scene:CreateNode(apollocore.Node.CT_CPU_EMITTER);
  else
    self.node = apollocore.CPUEmitter();
  end
  self.node._Script = self;
  self.ParticleModifier = self.node:AddModifier();  --更新修改器
  self.ParticleRenderer = self.node:GetParticleRenderer();
  self.RenerComponent = self.ParticleRenderer:GetBillboardRenderer();
  self.TransformComponent = self.node:GetTransformComponent();
end

function ParticleNode:CreateAffector()
  --affector 不做动态删减，只做启用或禁用
  self:AddLifeTimeAffector(mathfunction.vector1(1.0),mathfunction.vector1(2.0));  --生命周期
  self:AddDensityAffector(mathfunction.vector1(20.0),mathfunction.vector1(40.0)); --发射密度
  self:AddColorAffector(mathfunction.vector4(1.0,1.0,1.0,1.0),mathfunction.vector4(1.0,1.0,1.0,1.0)); --颜色
  self:AddSpeedAffector(mathfunction.vector1(0.1),mathfunction.vector1(0.1)); --速度大小
  self:AddSizeAffector(mathfunction.vector1(0.01),mathfunction.vector1(0.01)); --粒子大小
  self:AddRotationAffector(mathfunction.vector3(0.0,0.0,0.0),mathfunction.vector3(0.0,0.0,0.0)); --粒子旋转
  self:AddDistrubanceAffector(mathfunction.vector1(0.0),mathfunction.vector1(0.0));  --粒子扰动
  self:AddAnimationAffector(mathfunction.vector2(1,1),1,0,0,0,false,0,0,0,0); --序列帧动画
  self:AddSphereAffector(mathfunction.vector3(0.0,0.0,0.0),0.1,true); --球形发射器
  self:AddHeimiSphereAffector(mathfunction.vector3(0.0,0.0,0.0),0.1,true); --半球发射器
  self:AddBoxAffector(mathfunction.vector3(0.0,0.0,0.0),0.1,0.1,0.1,0); --盒子发射器
  self:AddConeAffector(mathfunction.vector3(0.0,0.0,0.0),0.01,25,0.1,360,0); --圆锥发射器
  
  --发射器形状之间应该是互斥的！！！！
  --默认采用Cone发射器形状
  self:DisableAffector(22) --disable sphere shape by default
  self:DisableAffector(24) --disble box shape by default
  --self:DisableAffector(23) --disable cone shape by default
  self:DisableAffector(26) --disable HeimiSphere shape by default
end

--需要把Curve保存到脚本中
function ParticleNode:CreateCurve()
  self:AddCurve(apollocore.ParticleModifier.PARAM_ALPHA);  --alpha曲线
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_ALPHA,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(0.0,1.0));
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_ALPHA,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(1.0,1.0));
  
  self:AddCurve(apollocore.ParticleModifier.PARAM_LINEAR_VELOCITY); --速度曲线
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_LINEAR_VELOCITY,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(0.0,0.0));
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_LINEAR_VELOCITY,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(1.0,0.0));
  
  self:AddCurve(apollocore.ParticleModifier.PARAM_DAMPING); --阻尼曲线
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_DAMPING,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(0.0,0.0));
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_DAMPING,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(1.0,0.0));
  
  self:AddCurve(apollocore.ParticleModifier.PARAM_SCALE);  --缩放曲线
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_SCALE,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(0.0,1.0));
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_SCALE,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(1.0,1.0));
  
  self:AddCurve(apollocore.ParticleModifier.PARAM_ROT_X);  --绕X轴旋转曲线
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_ROT_X,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(0.0,0.0));
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_ROT_X,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(1.0,0.0));
  
  self:AddCurve(apollocore.ParticleModifier.PARAM_ROT_Y);  --绕Y轴旋转曲线
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_ROT_Y,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(0.0,0.0));
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_ROT_Y,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(1.0,0.0));
  
  self:AddCurve(apollocore.ParticleModifier.PARAM_ROT_Z);  --绕Z轴旋转曲线
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_ROT_Z,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(0.0,0.0));
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_ROT_Z,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(1.0,0.0));
  
  self:AddCurve(apollocore.ParticleModifier.PARAM_EXTERNAL_FORCE_X);  --X轴力曲线
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_EXTERNAL_FORCE_X,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(0.0,0.0));
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_EXTERNAL_FORCE_X,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(1.0,0.0));
  
  self:AddCurve(apollocore.ParticleModifier.PARAM_EXTERNAL_FORCE_Y);  --Y轴力曲线
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_EXTERNAL_FORCE_Y,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(0.0,0.0));
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_EXTERNAL_FORCE_Y,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(1.0,0.0));
  
  self:AddCurve(apollocore.ParticleModifier.PARAM_EXTERNAL_FORCE_Z);  --Z轴力曲线
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_EXTERNAL_FORCE_Z,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(0.0,0.0));
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_EXTERNAL_FORCE_Z,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(1.0,0.0));
  
  self:AddCurve(apollocore.ParticleModifier.PARAM_VERTEX_DISTURBANCE); --顶点位置扰动曲线
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_VERTEX_DISTURBANCE,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(0.0,0.0));
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_VERTEX_DISTURBANCE,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(1.0,0.0));
  
  self:AddCurve(apollocore.ParticleModifier.PARAM_ANIMATION_FRAME); --顶点位置扰动曲线
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_ANIMATION_FRAME,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(0.0,0.0));
  self:AddCurvePoint(apollocore.ParticleModifier.PARAM_ANIMATION_FRAME,apollocore.ParticleModifier.TANGENT_FREE,0.0,
    apollocore.ParticleModifier.TANGENT_FREE,0.0,mathfunction.vector2(1.0,0.0));
  
  self:AddColorGradient(); --颜色曲线
  self:AddColorPoint(0.0,mathfunction.vector3(1.0,1.0,1.0));
  self:AddColorPoint(1.0,mathfunction.vector3(1.0,1.0,1.0));
end

function ParticleNode:CreateMaterial()
  



  --self.RenerComponent:PushMetadata(
  --  apollocore.RenderObjectMaterialMetadata(
  --    apollocore.PathMetadata("comm:documents/material/particle_blend.material")));
  
  local materialEntity = apollocore.MaterialEntity();
  materialEntity:PushMetadata(apollocore.MaterialMetadata("comm:documents/material/particle_default.mat"));
  materialEntity:CreateResource();
  self.RenerComponent:ChangeMaterial(materialEntity,1);
  --采用将TextureMetadata融到MaterialMetadata中的方式
  --[[
  self.RenerComponent:PushMetadata(
    apollocore.RenderObjectMaterialMetadata(
      apollocore.PathMetadata("comm:documents/shaders/legacy/particle/particle_blend.material"),
      apollocore.RenderObjectTextureMetadata(
        apollocore.ShaderEntity.TEXTURE_DIFFUSE,
        apollocore.TextureFileMetadata(
          apollocore.TextureEntity.TU_STATIC,
          apollocore.TextureEntity.PF_AUTO,
          1, true,
          apollocore.TextureEntity.TW_CLAMP_TO_EDGE,
          apollocore.TextureEntity.TW_CLAMP_TO_EDGE,
          apollocore.TextureEntity.TF_LINEAR,
          apollocore.TextureEntity.TF_LINEAR_MIPMAP_LINEAR,
        "comm:documents/texture/particle/likexin.png"))));
        --]]

  --默认采用Cone发射器形状
    local bindboxV = mathfunction.Aabbox3d(
    mathfunction.vector3(-0.1,0,-0.1),
    mathfunction.vector3(0.1,0.1,0.1));
    self.RenerComponent:SetBindBox(bindboxV);
  
  --texture(默认纹理图片)
  --self.RenerComponent:PushMetadata(--传入纹理原始数据
  --  apollocore.RenderObjectTextureMetadata(
  --    apollocore.ShaderEntity.TEXTURE_DIFFUSE,
  --    apollocore.TextureFileMetadata(
  --      apollocore.TextureEntity.TU_STATIC,
  --      apollocore.TextureEntity.PF_AUTO,
  --      1, true,
  --      apollocore.TextureEntity.TW_CLAMP_TO_EDGE,
  --      apollocore.TextureEntity.TW_CLAMP_TO_EDGE,
  --      apollocore.TextureEntity.TF_LINEAR,
  --      apollocore.TextureEntity.TF_LINEAR_MIPMAP_LINEAR,
  --      "comm:documents/texture/particle/likexin.png")));
 
end

function ParticleNode:SetGlobalParameter()
  self.RenerComponent:SetParameter(globaloffsetslot,mathfunction.vector3(0.0,0.0,0.0));
  self.RenerComponent:SetParameter(globalscaleslot,mathfunction.vector3(1.0,1.0,1.0));
end


function ParticleNode:SetGravity(gravity)
  self.ParticleModifier:SetGravity(gravity);
end

function ParticleNode:SetLocalPosition(pos)
  self.TransformComponent:SetLocalPosition(pos);
end

function ParticleNode:SetLocalRotation(rot)
  self.TransformComponent:SetLocalRotation(rot);
end

function ParticleNode:SetLocalScale(scale)
  self.TransformComponent:SetLocalScale(scale);
end

function ParticleNode:Update(timespan)
  self.node:Update(timespan);
end

function ParticleNode:Start()
  if self.node then
    self.node:Start();
  end
end

function ParticleNode:Reset()
  if self.node then
    self.node:Reset();
  end
end

function ParticleNode:Stop()
  if self.node then
    self.node:Stop();
  end
end

function ParticleNode:AddUserscript(scriptpath)
  local func,errorstr = loadfile(venuscore.IFileSystem:PathAssembly(scriptpath));
  if not errorstr then
    local temp= func(); 
    local scriptEntity = temp(scriptpath);
    local pathDir, pathName = string.match(scriptpath, "(.+)[:/]([^/]*)%.%w+$");
    self.ScriptComponents["Userscript_"..pathName] = scriptEntity;
  end
end

function ParticleNode:DeleteUserscript(value)
  for k, v in pairs(self.ScriptComponents) do
    if v == value then
      self.ScriptComponents[k] = nil;
    end
  end
end
---------------------------------------------------------------------------------affectors---------------------------------------------------------------------------------------
--生命周期affector
function ParticleNode:AddLifeTimeAffector(min,max)
  local affectortype = 1;
  local datatype = 0;

  local affector = self.node:CreateAffector(affectortype);
  affector:SetRange(datatype,min,max);
  self.AffectorList[affectortype] = affector;
end

--发射密度affector
function ParticleNode:AddDensityAffector(min,max)
  local affectortype = 0;
  local datatype = 0;
  
  local affector = self.node:CreateAffector(affectortype);
  affector:SetRange(datatype,min,max);
  self.AffectorList[affectortype] = affector;
end

--颜色affector
function ParticleNode:AddColorAffector(min,max)
  local affectortype = 6;
  local datatype = 3;
  
  local affector = self.node:CreateAffector(affectortype);
  affector:SetRange(datatype,min,max);
  self.AffectorList[affectortype] = affector;
end

--速度affector
function ParticleNode:AddSpeedAffector(min,max)
  local affectortype = 2;
  local datatype = 0;
  
  local affector = self.node:CreateAffector(affectortype);
  affector:SetRange(datatype,min,max);
  self.AffectorList[affectortype] = affector;
end

--大小affector
function ParticleNode:AddSizeAffector(min,max)
  local affectortype = 4;
  local datatype = 0;
  
  local affector = self.node:CreateAffector(affectortype);
  affector:SetRange(datatype,min,max);
  self.AffectorList[affectortype] = affector;
end

--旋转affector
function ParticleNode:AddRotationAffector(min,max)
  local affectortype = 12;
  local datatype = 2;
  
  local affector = self.node:CreateAffector(affectortype);
  affector:SetRange(datatype,min,max);
  self.AffectorList[affectortype] = affector;
end

--随机扰动affector
function ParticleNode:AddDistrubanceAffector(min,max)
  local affectortype = 13;
  local datatype = 0;
  
  local affector = self.node:CreateAffector(affectortype);
  affector:SetRange(datatype,min,max);
  self.AffectorList[affectortype] = affector;
end

--序列帧动画affector
function ParticleNode:AddAnimationAffector(tiles,cycles,animMode,minRow,maxRow,
    bConstantFrame,minConstantFrame,maxConstantFrame,minStartFrame,maxStartFrame)
  local affectortype = 21;
  
  local affector = self.node:CreateAffector(affectortype);
  affector:SetTiles(tiles);
  affector:SetMode(animMode);
  affector:SetCycles(cycles);
  

  if animMode ~= 0 and minRow~= nil and maxRow ~= nil then   --SingleRow 模式
    local rowMin = mathfunction.vector1(minRow);
    local rowMax = mathfunction.vector1(maxRow);
    local rowDatatype = 0;
    affector:SetRow(rowDatatype,rowMin,rowMax);
  end
  if bConstantFrame == true and minConstantFrame ~= nil and maxConstantFrame ~= nil then
    local frameMin = mathfunction.vector1(minConstantFrame);
    local frameMax = mathfunction.vector1(maxConstantFrame);
    local frameDatatype = 0;
    affector:SetConstantFrame(frameDatatype,frameMin,frameMax);
  end
  if minStartFrame ~= nil and maxStartFrame ~= nil then
    local startMin = mathfunction.vector1(minStartFrame);
    local startMax = mathfunction.vector1(maxStartFrame);
    local startDatatype = 0;
    affector:SetStartFrame(startDatatype,startMin,startMax);
  end
  self.AffectorList[affectortype] = affector;
end

--球形发射器
function ParticleNode:AddSphereAffector(center,radius,emitterfromshell)
  local affectortype = 22;
  
  local affector = self.node:CreateAffector(affectortype);
  affector:SetCenter(center);
  affector:SetRadius(radius);
  affector:SetEmitterFromShell(emitterfromshell);
  self.AffectorList[affectortype] = affector;
end

--半球发射器
function ParticleNode:AddHeimiSphereAffector(center,radius,emitfromshell)
  local affectortype = 26;
  
  local affector = self.node:CreateAffector(affectortype);
  affector:SetCenter(center);
  affector:SetRadius(radius);
  affector:SetEmitterFromShell(emitfromshell);
  self.AffectorList[affectortype] = affector;
end

--box发射器
function ParticleNode:AddBoxAffector(center,x,y,z,emitmode)
  local affectortype = 24;
  
  local affector = self.node:CreateAffector(affectortype);
  affector:SetCenter(center);
  affector:SetWidth(x);
  affector:SetHeight(y);
  affector:SetDepth(z);
  affector:SetEmiterFromMode(emitmode);
  self.AffectorList[affectortype] = affector;
end

--圆锥发射器
function ParticleNode:AddConeAffector(center,radius,angle,length,arcangle,emitmode)
  local affectortype = 23;
  
  local affector = self.node:CreateAffector(affectortype);
  affector:SetCenter(center);
  affector:SetRadius(radius);
  affector:SetLength(length);
  affector:SetAngle(angle);
  affector:SetEmitterFromMode(emitmode);
  self.AffectorList[affectortype] = affector;
end

--圆形发射器
function ParticleNode:AddCircleAffector(center,radius,emitfromshell)
  local affectortype = 25;
  
  local affector = self.node:CreateAffector(affectortype);
  affector:SetCenter(center);
  affector:SetRadius(radius);
  affector:SetEmiterFromMode(emitfromshell);
end

function ParticleNode:EnableAffector(affectorType)
  local affector = self.AffectorList[affectorType];
  if affector then
    affector:Enable();
  end
end

function ParticleNode:DisableAffector(affectorType)
  local affector = self.AffectorList[affectorType];
  if affector then
    affector:Disable();
  end
end

-------------------------------------------------------------------------Curve--------------------------------------------------------------------
function ParticleNode:GetCurveRange(paramType)
  if paramType == apollocore.ParticleModifier.PARAM_ALPHA then
    return mathfunction.vector2(0.0,1.0); 
  elseif paramType == apollocore.ParticleModifier.PARAM_LINEAR_VELOCITY then
    return mathfunction.vector2(0.0,10000.0); --速度曲线最大调节范围
  elseif paramType == apollocore.ParticleModifier.PARAM_DAMPING then
    return mathfunction.vector2(0.0,1.0); --速度阻尼曲线的最大调节范围
  elseif paramType == apollocore.ParticleModifier.PARAM_SCALE then
    return mathfunction.vector2(0.0,10000.0); --缩放曲线的调节范围
  elseif paramType == apollocore.ParticleModifier.PARAM_ROT_X then
    return mathfunction.vector2(-360.0,360.0);  --绕X轴旋转曲线的调节范围
  elseif paramType == apollocore.ParticleModifier.PARAM_ROT_Y then
    return mathfunction.vector2(-360.0,360.0);  --绕Y轴旋转曲线的调节范围
  elseif paramType == apollocore.ParticleModifier.PARAM_ROT_Z then
    return mathfunction.vector2(-360.0,360.0);  --绕Z轴旋转曲线的调节范围
  elseif paramType == apollocore.ParticleModifier.PARAM_EXTERNAL_FORCE_X then
    return mathfunction.vector2(-10000.0,10000.0); --X轴作用力的调节范围
  elseif paramType == apollocore.ParticleModifier.PARAM_EXTERNAL_FORCE_Y then
    return mathfunction.vector2(-10000.0,10000.0);  --Y轴作用力的调节范围
  elseif paramType == apollocore.ParticleModifier.PARAM_EXTERNAL_FORCE_Z then
    return mathfunction.vector2(-10000.0,10000.0);  --Z轴作用力的调节范围
  elseif paramType == apollocore.ParticleModifier.PARAM_VERTEX_DISTURBANCE then
    return mathfunction.vector2(0.0,1.0);   --顶点扰动的调节范围
  elseif paramType == apollocore.ParticleModifier.PARAM_ANIMATION_FRAME then
    local particlAnimation = self.AffectorList[21]; --粒子序列帧动画affector,从此affector中拿到粒子序列帧动画曲线的调节范围
    if particlAnimation then
      local tiles = particlAnimation.AnimationTiles;
      if tiles then
        return mathfunction.vector2(0.0,tiles:x() * tiles:y());
      end
    end
    return mathfunction.vector2(0.0,1.0);  --默认序列帧动画调节范围
  end

end

function ParticleNode:AddCurve(paramType)
  local curve = self.ParticleModifier:AddCurveParameter(paramType);
  local range = self:GetCurveRange(paramType);
  --设置
  curve:SetMinValue(range:x());
  curve:SetMaxValue(range:y());
  self.CurveList[tostring(paramType)] = curve;  --把所有曲线保存下来
end 

function ParticleNode:RemoveCurve(paramType)
  self.ParticleModifier:RemoveCurveParameter(paramType);
end

function ParticleNode:AddCurvePoint(paramType,left_mode,left_tangent,right_mode,right_tangent,point)
  self.ParticleModifier:AddCurvePoint(paramType,point,left_tangent,right_tangent,left_mode,right_mode);
end

--颜色曲线特殊处理
function ParticleNode:AddColorGradient()
  self.ParticleModifier:AddColorGradient();
end

function ParticleNode:RemoveColorGradient()
  self.ParticleModifier:RemoveColorGradient();
end

function ParticleNode:AddColorPoint(offset,color)
  self.ParticleModifier:AddColorPoint(offset,color);
end

function ParticleNode:RemoveColorPoint(index)
  self.ParticleModifier:RemoveColorPoint(index);
end


function ParticleNode:OnSerializeStarted()
end

function ParticleNode:OnSerializeFinished()
end


function ParticleNode:OnDeserializeFinished()
end

function ParticleNode:SetLayer(layer)
  self.node:SetLayer(layer);
end

function ParticleNode:GetComponent(ct)
  local component = nil;
  if self.node then
    component = self.node:GetComponent(ct);
  end
  return component;
end

function ParticleNode:GetBillboardRender()
  local particleRender = self.node:GetParticleRenderer();
  local billboardRender = particleRender:GetBillboardRenderer();
  return billboardRender;
end

function ParticleNode:GetMeshRender()
  local particleRender = self.node:GetParticleRenderer();
  local meshRender = particleRender:GetMeshRenderer();
  return meshRender;
end

--当发射模式为mesh时的模板Node(因为compoment只能由Node创建所有有一个模板Node）
--暴露出这个模板Node是为了能在命令间同步
function ParticleNode:GetMeshTemplateNode()
  local particleRender = self.node:GetParticleRenderer();
  local meshNode = particleRender:GetMeshNode();
  return meshNode;
end



return ParticleNode;
