local apollocore = require "apollocore"
local venuscore = require "venuscore"


local _fDeleteComponent = apollocore.Node.DeleteComponent;

function apollocore.Node:OnDeserializeFinished()
  local components = self.Components;
  for comType, comp in pairs(components) do
    local typename = comp:GetTypeName();
    if venuscore.BundleSystem.DeserializeFinishedDelegates[typename] then  
      local func = venuscore.BundleSystem.DeserializeFinishedDelegates[typename];
      func(comp,nil);
    end
    comp:Awake();  --统一调用Component的Awake
    local instances = comp.Instances;
    if instances then
      for key,value in pairs(instances) do
        value:Awake(); --ScripComponent 脚本的Awake
      end
    end
  end
end

function apollocore.Node:OnSerializeStarted()
  local components = self.Components;
  for comType, comp in pairs(components) do
    local typename = comp:GetTypeName();
    if venuscore.BundleSystem.SerializeStartedDelegates[typename] then  
      local func = venuscore.BundleSystem.SerializeStartedDelegates[typename];
      func(comp,nil);
    end
  end 
end

function apollocore.Node:Update(def)
  local components = self.Components;
  for comType, com in pairs(components) do
    com:Update(def);
    --测试ScriptComponent的Update
    if com.Instances then
      for scrKey,scrValue in pairs(com.Instances) do
        if scrValue then
          scrValue:Update(def);
        end
      end
    end
  end
end

function apollocore.Node:DeleteComponent(compType)
  local com = self:GetComponent(compType);
  if com then
    com:Destroy();
  end
  _fDeleteComponent(self,compType);
end

return apollocore.Node;