local mathfunction = require "mathfunction"
local apollocore = require "apollocore"
local venuscore = require "venuscore"
local cv = require "computervisionfunction"


local VenusBehavior = require "venuscore.behavior.venusbehavior"

local GenericNode =  venuscore.ActorNode:extend("GenericNode");


--[[
venuscore.BundleSystem:OnSerialize("Layer",
        function(obj)
          return "string",tostring(tonumber(obj));
        end
)

venuscore.BundleSystem:OnSerialize("LayerMask",
        function(obj)
          return "string",tostring(tonumber(obj));
        end
)
--]]

venuscore.BundleSystem:OnDeserialize(GenericNode:GetTypeName(),
        function(cls,attributes,nodes)
          for name,attr in pairs(attributes) do
            if string.find(name,'ChildNodes') then
              for k, v in pairs(attr) do
                cls:AttachNode(v);
              end 
            end
          end
          table.insert(nodes,cls);
        end)

--Node的layer需要调用转换为number
venuscore.BundleSystem:OnDeserialize(apollocore.Node:GetTypeName(),
        function(cls,attributes)
          for name, attr in pairs(attributes) do
              if name == "Layer" then
                local layer = venuscore.Utility:ConvertStringToUInt64(attr);
                cls[name] = layer;
              else
                cls[name] = attr;
              end
          end
        end
)

venuscore.BundleSystem:OnDeserialize(apollocore.TextNode:GetTypeName(),
        function(cls,attributes)
          for name, attr in pairs(attributes) do
            if name == "Layer" then
              local layer = venuscore.Utility:ConvertStringToUInt64(attr);
              cls[name] = layer;
            else
              cls[name] = attr;
            end
          end
          cls:CreateResource();
          local vertexstream = apollocore.VertexStream();
          vertexstream:SetVertexType(apollocore.ShaderEntity.ATTRIBUTE_POSITION,
                  apollocore.VertexBufferEntity.DT_FLOAT,
                  apollocore.VertexBufferEntity.DT_HALF_FLOAT, 2);
          vertexstream:SetVertexType(apollocore.ShaderEntity.ATTRIBUTE_COORDNATE0,
                  apollocore.VertexBufferEntity.DT_FLOAT,
                  apollocore.VertexBufferEntity.DT_HALF_FLOAT, 2);
          vertexstream:SetVertexType(apollocore.ShaderEntity.ATTRIBUTE_COLOR0,
                  apollocore.VertexBufferEntity.DT_FLOAT,
                  apollocore.VertexBufferEntity.DT_HALF_FLOAT, 4);
          --创建索引流
          local indicesstream = apollocore.IndicesStream();
          indicesstream:SetIndicesType(
                  apollocore.IndicesBufferEntity.IT_UINT16);
          local render = cls:GetComponent(apollocore.Node.CT_RENDER);
          render:PushMetadata(
                  apollocore.RenderObjectMeshMetadate(
                          apollocore.RenderComponent.RM_TRIANGLES,
                          apollocore.ReferenceVertexMetadata(
                                  apollocore.VertexBufferEntity.MU_DYNAMIC,--使用可以修改的显存区域
                                  vertexstream),
                          apollocore.ReferenceIndicesMetadata(
                                  apollocore.VertexBufferEntity.MU_DYNAMIC,--使用不可修改的显存区域
                                  indicesstream)));
          render:CreateResource();
          cls:RenderText();
        end
)

--CameraComponent的layer需要调用转换为number
venuscore.BundleSystem:OnDeserialize(apollocore.CameraComponent:GetTypeName(),
        function(cls,attributes) --cls is cameracomponent
          for name, attr in pairs(attributes) do
              if name == "LayerMask" then
                local layer = venuscore.Utility:ConvertStringToUInt64(attr);
                cls[name] = layer;
              else
                cls[name] = attr;
              end
          end

          for name,attr in pairs(attributes) do 
            if name == "PosteffctList" then
              local posteffectlist = attr;
              for key,value in pairs(posteffectlist) do
                local post = value["PostEffectEntity"];
                if value["Status"] == true then
                  cls:AttachPostEffect(post);
                end
              end
            end
          end

          if venuscore.BundleSystem.isPreView == true then
            cls:SetGameCamera();
          end
          
        end
)
      
--RenderComponent需要调用CeateResource
venuscore.BundleSystem:OnDeserialize(apollocore.RenderComponent:GetTypeName(),
  function(cls,attributes)
    for name, attr in pairs(attributes) do
        if name == "BindBox" then
          cls["OriginalBindBox"] = attr;
        else
          cls[name] = attr;
        end
    end
    if cls:GetHostNode():GetTypeName() == "SpineNode" or cls:GetHostNode():GetTypeName() == "TextNode" then
      return;
    end
    cls:CreateResource();
  end
)

--反序列化遗留问题：按照类的注册属性遍历赋值，无法保证顺序
venuscore.BundleSystem:OnDeserialize(apollocore.MaterialEntity:GetTypeName(),
  function(cls,attributes)
    local version = attributes["Version"];
    if not version or version == 1 then  --旧版本材质
      local materialMeta = attributes["SourceMetadata"];
      local shaderPath = attributes["ShaderPath"];
      local parameterList = attributes["ParameterList"];
      
      cls["SourceMetadata"] = materialMeta;
      cls:CreateResource();
      local ischange = false
      if shaderPath and shaderPath ~= cls:GetShaderPath() then
        cls:ChangeShaderPath(shaderPath);
        ischange = true
      end
      if cls.ParameterList then  --最早的材质（比如漫画贴纸)
        cls["ParameterList"] = parameterList;
      else
        for key,value in pairs(parameterList) do
          cls:SetParameter(key,value);
        end
      end
      if ischange and _KRATOSEDITOR then
        local mat = require "window.editor.widget.inspector.panels.assets.mat"
        mat.SaveOneMat(cls, shaderPath)
      end
    elseif version == 2 then  --新版本材质
      for k, v in pairs(attributes) do
        cls[k] = v;
      end
    end
  end
)

--PosteffectEntity需要调用CeateResource
venuscore.BundleSystem:OnDeserialize(apollocore.PostEffectEntity:GetTypeName(),
  function(cls,attributes)
    local parameterlist = nil;
    local queue = nil;
    for name, attr in pairs(attributes) do
      if name == "ScriptPath" then
        local MeshData = attr;
        local path = MeshData[1].Path;
        cls:PushMetadata(apollocore.PathMetadata(path));
        cls:CreateResource();
      elseif name == "Queue" then
        queue = attr;
      else
        parameterlist = attr;
      end
    end
    cls.Parameters = parameterlist; 
    cls.Queue = queue;
  end
)

--RenderTargetEntity需要调用CeateResource
venuscore.BundleSystem:OnDeserialize(apollocore.RenderTargetEntity:GetTypeName(),
  function(cls,attributes)
    for name, attr in pairs(attributes) do
      if attr then
        cls[name] = attr;
      end
    end
    cls:CreateResource();
  end
)

--ScriptComponent反序列化特殊处理
venuscore.BundleSystem:OnDeserialize(apollocore.ScriptComponent:GetTypeName(),
  function(cls,attributes)
    for name, attr in pairs(attributes) do
      if name == "Instances" then
        local instances = attr;
        for path,data in pairs(instances) do
          cls:InsertInstance(data, path);
          data:SetUniqueKey(cls:GetContentPath(),path);
        end
      else
        cls[name] = attr;
      end
    end
  end
)

venuscore.BundleSystem:OnDeserialize(apollocore.ClothComponent:GetTypeName(),
  function(cls, attributes)
    for name, attr in pairs(attributes) do
        if attr then
          cls[name] = attr;
        end
    end
    cls:CreateResource();
  end
)

venuscore.BundleSystem:OnSerializeStarted(apollocore.ClothComponent:GetTypeName(),
  function(component,data)
    component:OnSerializeStarted();
  end
)

venuscore.BundleSystem:OnDeserialize(apollocore.RigidBodyComponent:GetTypeName(),
  function(cls, attributes)
    cls["Shape"] =attributes["Shape"] 
    for name, attr in pairs(attributes) do
        if attr and name~="Shape" then
          cls[name] = attr;
        end
    end
  end
)

venuscore.BundleSystem:OnDeserializeInit(apollocore.ScriptComponent:GetTypeName(),
  function(host, typename, path)
    local instance = venuscore.LoadBehavior(path);
    return instance;
  end
)

-- MorpherComponent需要调用CeateResource
venuscore.BundleSystem:OnDeserialize(apollocore.MorpherComponent:GetTypeName(),
      function(cls,attributes)
        for name, attr in pairs(attributes) do
          if attr then
            cls[name] = attr;
          end
        end
        cls:CreateResource();
      end
)

venuscore.BundleSystem:OnDeserialize(apollocore.AnimationComponent:GetTypeName(),
  function(cls,attributes)
    for name, attr in pairs(attributes) do
          cls[name] =attr;
    end
  end
)

venuscore.BundleSystem:OnSerializeStarted(apollocore.AnimationComponent:GetTypeName(),
  function(component,data)
    component:OnSerializeStarted();
  end
)

venuscore.BundleSystem:OnSerializeFinished(apollocore.AnimationComponent:GetTypeName(),
  function(component,data)
    component:OnSerializeFinished();
  end
)

venuscore.BundleSystem:OnDeserializeFinished(apollocore.ScriptComponent:GetTypeName(),
  function(component,data)
    --[[
    local instances = component.Instances;
    for key,value in pairs(instances) do
      value:Awake();
    end
    ]]--
  end
)

venuscore.BundleSystem:OnDeserializeFinished(apollocore.AnimationComponent:GetTypeName(),
  function(component,data)
    component:CreateResource();
    component:OnDeserializeFinished();
  end
)


venuscore.BundleSystem:OnDeserializeFinished(apollocore.MorpherComponent:GetTypeName(),
        function(component,data)
          component:OnDeserializeFinished();
        end
)

venuscore.BundleSystem:OnDeserialize(apollocore.SkeletonComponent:GetTypeName(),
  function(cls,attributes)
    for name, attr in pairs(attributes) do
      if attr then
          cls[name] = attr;
      end
    end
  end
)

venuscore.BundleSystem:OnDeserializeFinished(apollocore.SkinComponent:GetTypeName(),
        function(component,data)
          component:OnDeserializeFinished();
        end
)

venuscore.BundleSystem:OnDeserializeFinished(apollocore.ClothComponent:GetTypeName(),
        function(component,data)
          component:Initialize();
          component:OnDeserializeFinished();
        end
)

--TextureEntity需要调用CeateResource
venuscore.BundleSystem:OnDeserialize(apollocore.TextureEntity:GetTypeName(),
  function(obj, attributes)
    for name, attr in pairs(attributes) do
      if attr then
        obj[name] = attr;
      end
    end
    obj:CreateResource();
  end
)

venuscore.BundleSystem:OnDeserialize(apollocore.EditorKeyFrameMetaData:GetTypeName(),
        function(obj, attributes)
          for name, attr in pairs(attributes) do
            if attr then
              obj[name] = attr;
            end
          end
          if _KRATOSEDITOR then
            obj:SetSceneID(venuscore.BundleSystem.CurrentScene:GetStaticID());
          end
        end
)


venuscore.BundleSystem:OnDeserialize(apollocore.MaterialMetadata:GetTypeName(),
        function(obj, attributes)
          for name, attr in pairs(attributes) do
            if attr then
              obj[name] = attr;
            end
          end
          if _KRATOSEDITOR then
            obj:SetSceneID(venuscore.BundleSystem.CurrentScene:GetStaticID());
          end
        end
)

venuscore.BundleSystem:OnDeserialize(cv.SegmentComponent:GetTypeName(),
        function(obj, attributes)
          for name, attr in pairs(attributes) do
            if attr then
              obj[name] = attr;
            end
          end
          --obj:Awake();
        end
)

venuscore.BundleSystem:OnDeserialize(cv.ClassifyComponent:GetTypeName(),
        function(obj, attributes)
          for name, attr in pairs(attributes) do
            if attr then
              obj[name] = attr;
            end
          end
          --obj:Awake();
        end
)

venuscore.BundleSystem:OnDeserializeFinished(apollocore.FrameAnimationComponent:GetTypeName(),
  function(component,data)
      component:Awake();
  end
)

GenericNode:MemberRegister("node");
GenericNode:MemberRegister("_version");


--isDeserialize: 标识是否是通过反序列化创建对象
function GenericNode:new(scene)
  --GenericNode.super.new(self);
  if scene then
    self.node = scene:CreateNode(apollocore.Node.CT_NODE);
  else
    self.node = apollocore.Node();
  end

  --需要保证在CeateComponent之前设置UUID
  
  --self.node._Script = self;
  self._trans = self:CreateComponent(apollocore.Node.CT_TRANSFORM); --默认会有一个transform component
  self._trans:SetLocalPosition(mathfunction.vector3(0.0,0.0,0.0));
  self._version = 1;
end

function GenericNode:SetLocalRotation(q)
  self._trans:SetLocalRotation(q);
end

function GenericNode:CreateComponent(ct)
  local component = nil;
  if self.node then
    component = self.node:CreateComponent(ct);
  end
  return component;
end

function GenericNode:GetComponent(ct)
  local component = nil;
  if self.node then
    component = self.node:GetComponent(ct);
  end
  return component;
end


function GenericNode:Update(def)
  local components = self.node.Components;
  for comType, com in pairs(components) do
    com:Update(def);
    
    --测试ScriptComponent的Update
    if com.Instances then
      for scrKey,scrValue in pairs(com.Instances) do
        if scrValue then
          scrValue:Update(def);
        end
      end
    end
  end

end


function GenericNode:SetLayer(layer)
  self.node:SetLayer(layer);
end


function GenericNode:OnSerializeFinished()
  --循环所有的component,调用其回调
  local components = self.node.Components;
  for comType, comp in pairs(components) do
    local typename = comp:GetTypeName();
      if venuscore.BundleSystem.SerializeFinishedDelegates[typename] then  
        local func = venuscore.BundleSystem.SerializeFinishedDelegates[typename];
        func(comp,nil);
    end
  end
end


function GenericNode:OnDeserializeFinished()
  --循环所有的component,调用其回调
  local components = self.node.Components;
  for comType, comp in pairs(components) do
    local typename = comp:GetTypeName();
    if venuscore.BundleSystem.DeserializeFinishedDelegates[typename] then  
      local func = venuscore.BundleSystem.DeserializeFinishedDelegates[typename];
      func(comp,nil);
    end
    comp:Awake();  --统一调用Component的Awake
    local instances = comp.Instances;
    if instances then
      for key,value in pairs(instances) do
        value:Awake(); --ScripComponent 脚本的Awake
      end
    end
  end
end

function GenericNode:GetNativeNode()
  return self.node;
end

return GenericNode;