local apollocore = require "apollocore"


local DeviceResource = {}
DeviceResource.ResourceList = {}

DeviceResource.DEVICE_CAPTURE = "DEVICE_CAPTURE";   --摄像头采集数据资源

DeviceResource.DEVICE_SEGMENT = "DEVICE_SEGMENT"; 
--设置一个系统提供的数据对象
function DeviceResource:PushDeviceResource(name, entity)
  local typename = entity:GetTypeName();
  if entity:isType(apollocore.TextureEntity:RTTI()) then
    local texfrom = apollocore.TextureEntity();
    texfrom:PushMetadata(apollocore.TextureReferenceMetadata(name));
    apollocore.IResourceSystem:RedirectResource(texfrom, entity);
    local reslist = self.ResourceList[typename] or {}
    local isExist = false;
    for k,v in ipairs(reslist) do
      if v == name then
        isExist = true;
      end
    end
    if not isExist then
      table.insert(reslist, name);
    end
    self.ResourceList[typename] = reslist;
  else
    error("unsupport resource type " .. typename);
  end  
end

--传入类型返回数据数组
function DeviceResource:GetDeviceResources(type_rtti)  
  local typename = type_rtti:GetTypeName();
  return self.ResourceList[typename];
end

return DeviceResource;