local apollocore = require "apollocore"


local stringPlay = "Play"

rawset(apollocore.FrameAnimationComponent, "GetProperties",
  function(self, type_name)
    local res = apollocore.IContent.GetProperties(self, type_name); --先取得其余的属性
    local entitys = self.aniEntityArray;
    for index, entity in ipairs(entitys) do
      local propString = string.format(
        "aniEntityArray%s%d%s%s", 
        self.SEP, 
        index, 
        self.SEP, 
        stringPlay
      );
      table.insert(res, propString);
    end
    return res;
  end);


rawset(
  apollocore.FrameAnimationComponent,
  "GetScriptPropValue",
  function(self, prop)
    if string.find(prop, stringPlay) then
      local keys = string.split(prop, self.SEP);
      local index = tonumber(keys[2]);
      local entity = self.aniEntityArray[index];
      local status = entity:GetAnimationStatus();
      return status == apollocore.IComponent.AS_PLAYING;
    end
    return apollocore.IContent.GetScriptPropValue(self, prop);
  end
);

rawset(
  apollocore.FrameAnimationComponent,
  "SetScriptPropValue",
  function(self, prop, value)
    if string.find(prop, stringPlay) then
      local keys = string.split(prop, self.SEP);
      local index = tonumber(keys[2]);
      if value then
        self:Play(index - 1); --现在统一从component调用play感觉有点难受
      else
        self:Stop(index - 1);
        self:Reset(index - 1);
      end
    else
      apollocore.IContent.SetScriptPropValue(self, prop, value);
    end
  end
);

local _nativeUpdate = apollocore.FrameAnimationComponent.Update

rawset(
  apollocore.FrameAnimationComponent,
  "Update",
  function(self, delta)
    if not self:isActiveHierarchy() then
      return
    end
    local entities = self.aniEntityArray
    for i = 1, #entities do
      local entity = entities[i]
      local status = entity:GetAnimationStatus()
      local isPlaying  = status == apollocore.IComponent.AS_PLAYING
      local hasDone    = status == apollocore.IComponent.AS_DONE
      local hasStopped = status == apollocore.IComponent.AS_STOP
      if entity.autoShowHideRenders then
        local renderCount = entity:GetBindRenderComponentNum()
        for j = 1, renderCount do
          local render = entity:GetBindRenderComponent(j - 1)
          if render then
            if isPlaying then
              if not render.Active then
                render.Active = true
              end
            elseif hasDone or hasStopped then
              if render.Active then
                render.Active = false
              end
            end
          end
        end
      end
    end
    _nativeUpdate(self, delta)
  end
);