local apollocore = require "apollocore"


if _KRATOSEDITOR then
  local fbxfunc = require "fbxtool"

  local _fNativeOnSerializeStarted = apollocore.AnimationComponent.OnSerializeStarted;
  assert(_fNativeOnSerializeStarted);


  function apollocore.AnimationComponent:OnSerializeStarted()
      local saveInfos = self:GetSaveCurvesInfo();
      fbxfunc.FbxTool:AddAnimationSaveInfo(saveInfos);
  end
end

local stringPlay = "Play"

rawset(
  apollocore.AnimationComponent,
  "GetProperties",
  function(self, typeName)
    local res = apollocore.IContent.GetProperties(self, typeName); --先取得其余的属性
    table.insert(res, stringPlay);
    return res;
  end
);

rawset(
  apollocore.AnimationComponent,
  "GetScriptPropValue",
  function(self, prop)
    if prop == stringPlay then
      local status = self:GetAnimationStatus()
      return status == apollocore.IComponent.AS_PLAYING
    end
    return apollocore.IContent.GetScriptPropValue(self, prop);
  end
);

rawset(
  apollocore.AnimationComponent,
  "SetScriptPropValue",
  function(self, prop, value)
    if prop == stringPlay then
      if value then
        self:Play()
      else
        self:Stop()
        self:Reset()
      end      
    else
      apollocore.IContent.SetScriptPropValue(self, prop, value);
    end
  end
);