
#DEFPARAMS
RGB_TEXTURE = { "main Color", TEXTURE2D, "0.0,0.0" },
THRESHOLD = {"Threshold", FLOAT, "0.0"}
#END

#DEFTAG
ShaderName = "ShineLight"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D RGB_TEXTURE; 
float THRESHOLD;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}


float4 frag(v2f i) : SV_Target
{
    float threshold = float(THRESHOLD);
	float3 rgb = tex2D(RGB_TEXTURE, i.uv).xyz + 0.5 / 255.0;
    float3 coeff = float3(0.299, 0.587, 0.114);
    float bright = dot(coeff, rgb);
    float3 finalRgb = bright > threshold ? rgb : float3(0.0, 0.0, 0.0);
	return float4(finalRgb, 1.0);
}
ENDCG
#END