#DEFPARAMS
DIVERGENCE = {"DIVERGENCE", TEXTURE2D, "DIVERGENCE"},
PRESSURE   = {"PRESSURE", TEXTURE2D, "PRESSURE"},
TEXEL_SIZE = {"TEXEL_SIZE", VEC2, "64.0, 64.0"},
FLOAT_MIN  = {"FLOAT_MIN", FLOAT, "-100.0"},
FLOAT_MAX  = {"FLOAT_MAX", FLOAT, "100.0"},
#END

#DEFTAG
ShaderName  = "PressureStep"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 center_uv: TEXCOORD0;
    float2 left_uv:   TEXCOORD1;
    float2 right_uv:  TEXCOORD2;
    float2 top_uv:    TEXCOORD3;
    float2 bottom_uv: TEXCOORD4;

    float4 vertex : SV_POSITION;
};

sampler2D DIVERGENCE;
sampler2D PRESSURE;
float2    TEXEL_SIZE;
float     FLOAT_MIN;
float     FLOAT_MAX;

v2f vert(appdata v)
{
    v2f o;
    o.vertex = UniformNDC(v.vertex);

    o.center_uv = v.uv.xy;
    o.left_uv   = o.center_uv - float2(TEXEL_SIZE.x, 0.0);
    o.right_uv  = o.center_uv + float2(TEXEL_SIZE.x, 0.0);
    o.top_uv    = o.center_uv + float2(0.0, TEXEL_SIZE.y);
    o.bottom_uv = o.center_uv - float2(0.0, TEXEL_SIZE.y);

    return o;
}

float4 frag(v2f i) : SV_Target
{
    float range  = FLOAT_MAX - FLOAT_MIN;
    float left   = tex2D(PRESSURE, i.left_uv).x * range + FLOAT_MIN;
    float right  = tex2D(PRESSURE, i.right_uv).x * range + FLOAT_MIN;
    float top    = tex2D(PRESSURE, i.top_uv).x * range + FLOAT_MIN;
    float bottom = tex2D(PRESSURE, i.bottom_uv).x * range + FLOAT_MIN;
    float center = tex2D(PRESSURE, i.center_uv).x * range + FLOAT_MIN;
    float divergence = tex2D(DIVERGENCE, i.center_uv).x * range + FLOAT_MIN;
    float pressure = (left + right + bottom + top - divergence) * 0.25;
    pressure = (pressure - FLOAT_MIN) / range;

    return float4(pressure, 0.0, 0.0, 1.0);
}
ENDCG
#END