#DEFPARAMS
LAST_FRAME = {"LAST_FRAME", TEXTURE2D, "LAST_FRAME"},
CUR_FRAME  = {"CUR_FRAME", TEXTURE2D, "CUR_FRAME"},
TEXEL_SIZE = {"TEXEL_SIZE", VEC2, "64.0, 64.0"},
#END

#DEFTAG
ShaderName  = "MotionVectorStep"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};

sampler2D LAST_FRAME;
sampler2D CUR_FRAME;
float2    TEXEL_SIZE;

v2f vert(appdata v)
{
    v2f o;
    o.vertex = UniformNDC(v.vertex);
    o.uv = v.uv.xy;

    return o;
}

float4 frag(v2f i) : SV_Target
{
    float2 tex_coord_00 = i.uv - TEXEL_SIZE;
    float2 tex_coord_01 = i.uv + float2(0.0, -TEXEL_SIZE.y);
    float2 tex_coord_02 = i.uv + float2(TEXEL_SIZE.x, -TEXEL_SIZE.y);

    float2 tex_coord_10 = i.uv + float2(-TEXEL_SIZE.x, 0.0);
    float2 tex_coord_11 = i.uv;
    float2 tex_coord_12 = i.uv + float2(TEXEL_SIZE.x, 0.0);

    float2 tex_coord_20 = i.uv + float2(-TEXEL_SIZE.x, TEXEL_SIZE.y);
    float2 tex_coord_21 = i.uv + float2(0.0, TEXEL_SIZE.y);
    float2 tex_coord_22 = i.uv + TEXEL_SIZE;

    float3 pre_color_00 = tex2D(LAST_FRAME, tex_coord_00).rgb;
    float3 pre_color_01 = tex2D(LAST_FRAME, tex_coord_01).rgb;
    float3 pre_color_02 = tex2D(LAST_FRAME, tex_coord_02).rgb;

    float3 pre_color_10 = tex2D(LAST_FRAME, tex_coord_10).rgb;
    float3 pre_color_11 = tex2D(LAST_FRAME, tex_coord_11).rgb;
    float3 pre_color_12 = tex2D(LAST_FRAME, tex_coord_12).rgb;

    float3 pre_color_20 = tex2D(LAST_FRAME, tex_coord_20).rgb;
    float3 pre_color_21 = tex2D(LAST_FRAME, tex_coord_21).rgb;
    float3 pre_color_22 = tex2D(LAST_FRAME, tex_coord_22).rgb;

    float3 cur_color_00 = tex2D(CUR_FRAME, tex_coord_00).rgb;
    float3 cur_color_01 = tex2D(CUR_FRAME, tex_coord_01).rgb;
    float3 cur_color_02 = tex2D(CUR_FRAME, tex_coord_02).rgb;

    float3 cur_color_10 = tex2D(CUR_FRAME, tex_coord_10).rgb;
    float3 cur_color_11 = tex2D(CUR_FRAME, tex_coord_11).rgb;
    float3 cur_color_12 = tex2D(CUR_FRAME, tex_coord_12).rgb;

    float3 cur_color_20 = tex2D(CUR_FRAME, tex_coord_20).rgb;
    float3 cur_color_21 = tex2D(CUR_FRAME, tex_coord_21).rgb;
    float3 cur_color_22 = tex2D(CUR_FRAME, tex_coord_22).rgb;

    float3 coeff = float3(0.299, 0.587, 0.114); //rgb->gray

    float pre_y_00 = dot(coeff, pre_color_00);
    float pre_y_01 = dot(coeff, pre_color_01);
    float pre_y_02 = dot(coeff, pre_color_02);

    float pre_y_10 = dot(coeff, pre_color_10);
    float pre_y_11 = dot(coeff, pre_color_11);
    float pre_y_12 = dot(coeff, pre_color_12);

    float pre_y_20 = dot(coeff, pre_color_20);
    float pre_y_21 = dot(coeff, pre_color_21);
    float pre_y_22 = dot(coeff, pre_color_22);

    float pre_patch_total_y = pre_y_00 + pre_y_01 + pre_y_02 +
                              pre_y_01 + pre_y_11 + pre_y_12 +
                              pre_y_20 + pre_y_21 + pre_y_22;

    float cur_y_00 = dot(coeff, cur_color_00);
    float cur_y_01 = dot(coeff, cur_color_01);
    float cur_y_02 = dot(coeff, cur_color_02);

    float cur_y_10 = dot(coeff, cur_color_10);
    float cur_y_11 = dot(coeff, cur_color_11);
    float cur_y_12 = dot(coeff, cur_color_12);

    float cur_y_20 = dot(coeff, cur_color_20);
    float cur_y_21 = dot(coeff, cur_color_21);
    float cur_y_22 = dot(coeff, cur_color_22);

    float cur_patch_total_y = cur_y_00 + cur_y_01 + cur_y_02 +
                              cur_y_01 + cur_y_11 + cur_y_12 +
                              cur_y_20 + cur_y_21 + cur_y_22;

    //calculate gradient using scharr operator
    float2 patch_grad = float2( 0.1875 * (cur_y_02 - cur_y_00 + cur_y_22 - cur_y_20) + 0.625 * (cur_y_12 - cur_y_10),
                                0.1875 * (cur_y_20 - cur_y_00 + cur_y_22 - cur_y_02) + 0.625 * (cur_y_21 - cur_y_01));

    //revert grad if patch become brighter
    if(cur_patch_total_y > pre_patch_total_y)
        patch_grad *= -1.0;

    float abs_patch_y_ave_change = abs(cur_patch_total_y - pre_patch_total_y) / 9.0;
    
    //condition to trigger motion vector: luminance change sufficiently large
    float luminance_change_epsilon = 0.05;

    //enforce no motion vector at boundaries
    float2 boundary_margin = 1.0 * TEXEL_SIZE;
    bool is_inner = i.uv.x > boundary_margin.x && i.uv.x < 1.0 - boundary_margin.x && i.uv.y > boundary_margin.y && i.uv.y < 1.0 - boundary_margin.y;
    
    if(abs_patch_y_ave_change > luminance_change_epsilon && is_inner == true)
        return float4(patch_grad * 0.5 + 0.5, 0.0, 1.0); //normalize: [-1, 1] -> [0, 1]
    else
        return float4(0.5, 0.5, 0.0, 1.0);
}
ENDCG
#END