#DEFPARAMS
COLOR      = {"COLOR", TEXTURE2D, "COLOR"},
CUR_FRAME  = {"CUR_FRAME", TEXTURE2D, "CUR_FRAME"},
BLEND_MODE = {"BLEND_MODE", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName  = "BlendStep"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
#include "blendfunc.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};

sampler2D COLOR;
sampler2D CUR_FRAME;
float     BLEND_MODE;

v2f vert(appdata v)
{
    v2f o;
    o.vertex = UniformNDC(v.vertex);
    o.uv = v.uv.xy;

    return o;
}

float4 frag(v2f i) : SV_Target
{
    float4 color = tex2D(COLOR, i.uv);
    float4 base  = tex2D(CUR_FRAME, i.uv);
    int blend_mode   = int(BLEND_MODE + 0.5);
    float3 blend_color = blend(blend_mode, base.rgb, color.rgb);
    return float4(blend_color, color.a);
}
ENDCG
#END