#DEFPARAMS
ADVECT_SOURCE   = {"ADVECT_SOURCE", TEXTURE2D, "ADVECT_SOURCE"},
VELOCITY        = {"VELOCITY", TEXTURE2D, "VELOCITY"},
TEXEL_SIZE      = {"TEXEL_SIZE", VEC2, "64.0, 64.0"},
DISSIPATION     = {"DISSIPATION", FLOAT, "0.0"},
TIME_STEP       = {"TIME_STEP", FLOAT, "0.01"},
VEL_FLOAT_MIN   = {"VEL_FLOAT_MIN", FLOAT, "-100.0"},
VEL_FLOAT_MAX   = {"VEL_FLOAT_MAX", FLOAT, "100.0"},
SRC_FLOAT_MIN   = {"SRC_FLOAT_MIN", FLOAT, "-100.0"},
SRC_FLOAT_MAX   = {"SRC_FLOAT_MAX", FLOAT, "100.0"},
SRC_MULTI_PHASE = {"SRC_MULTI_PHASE", FLOAT, "0.0"},
SRC_PHASE_1     = {"SRC_PHASE_1", VEC3, "1.0, 0.0, 0.0"},
SRC_PHASE_2     = {"SRC_PHASE_2", VEC3, "1.0, 0.0, 0.0"},
SRC_PHASE_3     = {"SRC_PHASE_3", VEC3, "1.0, 0.0, 0.0"},
#END

#DEFTAG
ShaderName  = "AdvectionStep"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv: TEXCOORD0;
    float4 vertex : SV_POSITION;
};

sampler2D ADVECT_SOURCE;
sampler2D VELOCITY;
float2    TEXEL_SIZE;
float     DISSIPATION;
float     TIME_STEP;
float     VEL_FLOAT_MIN;
float     VEL_FLOAT_MAX;
float     SRC_FLOAT_MIN;
float     SRC_FLOAT_MAX;
float     SRC_MULTI_PHASE;
float3    SRC_PHASE_1;
float3    SRC_PHASE_2;
float3    SRC_PHASE_3;

v2f vert(appdata v)
{
    v2f o;
    o.vertex = UniformNDC(v.vertex);
    o.uv = v.uv.xy;

    return o;
}

float4 frag(v2f i) : SV_Target
{
    float  vel_range         = (VEL_FLOAT_MAX - VEL_FLOAT_MIN);
    float2 vel_float_min_vec = float2(VEL_FLOAT_MIN, VEL_FLOAT_MIN);
    float  src_range         = (SRC_FLOAT_MAX - SRC_FLOAT_MIN);
    float3 src_float_min_vec = float3(SRC_FLOAT_MIN, SRC_FLOAT_MIN, SRC_FLOAT_MIN);
    float2 vel               = vel_range * tex2D(VELOCITY, i.uv).xy + vel_float_min_vec;
    float2 coord             = i.uv - TIME_STEP * vel * TEXEL_SIZE;
    float4 normalized_result = tex2D(ADVECT_SOURCE, coord);
    float3 result            = src_range * normalized_result.xyz + src_float_min_vec;
    float  decay             = 1.0 + DISSIPATION * TIME_STEP;
    normalized_result.w      = normalized_result.w / decay;
    int use_multi_phase      = int(SRC_MULTI_PHASE + 0.5);
    if(use_multi_phase != 0)
    {
        float src_age      = 1.0 - normalized_result.w;
        float phase1_weight = src_age > 0.5 ? 0.0 : (0.5 - src_age) * 2.0;
        float phase3_weight = src_age > 0.5 ? (src_age - 0.5) * 2.0 : 0.0;
        float phase2_weight = 1.0 - max(phase1_weight, phase3_weight);
        result = phase1_weight * SRC_PHASE_1 + phase2_weight * SRC_PHASE_2 + SRC_PHASE_3;
    }
    else
    {
        result = result /decay;
    }
    normalized_result.xyz = (result - src_float_min_vec) / src_range;

    return normalized_result;
}
ENDCG
#END