

#DEFPARAMS
_MainTex = { "main Color", TEXTURE2D, "white" },
_MetallicGlossMap = {"Metallic Gloss", TEXTURE2D, "white"},
_BumpMap = {"Normal Map", TEXTURE2D, "bump"},
_GlossEnvMap = {"Specular IBL Map", TEXTURECUBE, "black"},
_Smoothness = {"Smoothness", FLOAT, "0.5" },
_Metallic = { "Metallic", FLOAT, "0.5" },
_EmissionColor = {"Emission Color", COLOR, "0.0,0.0,0.0,1.0"},
#END

#DEFTAG
ShaderName = "StandardPbr"
RenderQueue = "Opaque"
#END

#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdbase
#include "lightpbr.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float3 binoraml : BINORMAL;
	float3 tangent : TANGENT;
	float2 uv : TEXCOORD0;
	ANI_ATTRIBUTE
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 worldnormal : TEXCOORD1;
	float4 worldtangent : TEXCOORD2;
	float4 worldbinormal : TEXCOORD3;
	float4 vertex : SV_POSITION;
	SHADOW_COORDS(4)
};

sampler2D _MainTex;
sampler2D _MetallicGlossMap;
sampler2D _BumpMap;
samplerCUBE _GlossEnvMap;
float _Smoothness;
float _Metallic;
float4 _EmissionColor;

v2f vert(appdata v)
{
	COMPUTE_BONE_MATERIX(v);

	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;
	float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
	o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;
	o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;

	o.worldnormal.w = worldpos.x;
	o.worldtangent.w = worldpos.y;
	o.worldbinormal.w = worldpos.z;

	TRANSFER_SHADOW(o, v.vertex);
	return o;
}

float4 frag(v2f i) : SV_Target
{
	// sample the texture
	float4 col = tex2D(_MainTex, i.uv);
	float2 mg = tex2D(_MetallicGlossMap, i.uv).ra;
	float emissionMask = tex2D(_MetallicGlossMap, i.uv).g;
	float3 normalTangent = tex2D(_BumpMap, i.uv).rgb;
	normalTangent.xyz = normalTangent.xyz * 2.0 - 1.0;
	float3 normalWorld = normalTangent.x * i.worldtangent.xyz + normalTangent.y * i.worldtangent.xyz
		+ normalTangent.z * i.worldnormal.xyz;
	normalWorld.xyz = normalize(normalWorld.xyz);
	
	float roughness = 1.0 - mg.g * _Smoothness;
	float3 worldPos = float3(i.worldnormal.w, i.worldtangent.w, i.worldbinormal.w);
	float3 iblColor = SpecularIBLColor(_GlossEnvMap, worldPos, normalWorld, roughness);

	SurfaceStandardInput input;
	input.albedo = col.rgb;
	input.metallic = mg.r * _Metallic;
	input.smoothness = mg.g * _Smoothness;
	input.worldNormal = normalWorld; // normalWorld;
	input.worldPos = worldPos;
	input.emission = AmbientColor() + _EmissionColor.rgb * emissionMask;
	input.specularIbl = iblColor.rgb;
	input.atten = SHADOW_ATTEN(i);

	float4 outColor;
	outColor.xyz = PBR_LightCalc(input);
	outColor.w = 1.0;
	return outColor;
}
ENDCG

#END

#DEFPASS ForwardAdd
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, ONE, ONE, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDADD }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdadd
#include "lightpbr.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float3 binoraml : BINORMAL;
	float3 tangent : TANGENT;
	float2 uv : TEXCOORD0;
	ANI_ATTRIBUTE
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 worldnormal : TEXCOORD1;
	float4 worldtangent : TEXCOORD2;
	float4 worldbinormal : TEXCOORD3;
	float4 vertex : SV_POSITION;
	SHADOW_COORDS(4)
};

sampler2D _MainTex;
sampler2D _MetallicGlossMap;
sampler2D _BumpMap;
float _Smoothness;
float _Metallic;
float4 _EmissionColor;

v2f vert(appdata v)
{
	COMPUTE_BONE_MATERIX(v);

	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;
	float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
	o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;
	o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;

	o.worldnormal.w = worldpos.x;
	o.worldtangent.w = worldpos.y;
	o.worldbinormal.w = worldpos.z;

	TRANSFER_SHADOW(o, v.vertex);
	return o;
}

float4 frag(v2f i) : SV_Target
{
	// sample the texture
	float4 col = tex2D(_MainTex, i.uv);
	float2 mg = tex2D(_MetallicGlossMap, i.uv).ra;
	float3 normalTangent = tex2D(_BumpMap, i.uv).rgb;
	normalTangent.xyz = normalTangent.xyz * 2.0 - 1.0;
	float3 normalWorld = normalTangent.x * i.worldtangent.xyz + normalTangent.y * i.worldtangent.xyz
		+ normalTangent.z * i.worldnormal.xyz;
	normalWorld.xyz = normalize(normalWorld.xyz);

	SurfaceStandardInput input;
	input.albedo = col.rgb;
	input.metallic = mg.r * _Metallic;
	input.smoothness = mg.g * _Smoothness;
	input.worldNormal = normalWorld; // normalWorld;
	input.worldPos = float3(i.worldnormal.w, i.worldtangent.w, i.worldbinormal.w);
	input.emission = float3(0.0, 0.0, 0.0);
	input.atten = SHADOW_ATTEN(i);
	input.specularIbl = float3(0.0, 0.0, 0.0);

	float4 outColor;
	outColor.xyz = PBR_LightCalc(input);
	outColor.w = 1.0;
	return outColor;
}
ENDCG

#END

#DEFPASS Depth
	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	CGPROGRAM
	#pragma vertex vert
	#pragma fragment frag
	#include "lightpbr.inc"

	struct appdata
	{
		float4 vertex : POSITION;
		float3 normal : NORMAL;
		ANI_ATTRIBUTE
	};

	struct v2f
	{
		float4 vertex : SV_POSITION;
	};

	v2f vert(appdata v)
	{
		COMPUTE_BONE_MATERIX(v);

		float4 clipPos = ObjectToClipPos(v.vertex);
		clipPos = ApplyShadowBias(clipPos);

		v2f o;
		o.vertex = UniformNDC(clipPos);
		return o;
	}

	float4 frag(v2f i) : SV_Target
	{
		return float4(0.0, 0.0, 0.0, 1.0);
	}
	ENDCG
#END
