

#DEFPARAMS
_MainTex = { "main tex", TEXTURE2D, "white" }
#END

#DEFTAG
ShaderName = "Quad"
RenderQueue = "Background"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata   
{
	float4 vertex : POSITION;
	float2 uv0 : TEXCOORD0;
};

struct v2f
{
	float2 uv0 : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D _MainTex;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv0 = v.uv0;
	return o;
}

float4 frag(v2f i) : SV_Target
{
	// sample the texture
	float4 basecolor = tex2D(_MainTex, i.uv0);
    return basecolor;
}
ENDCG
#END
