

#DEFPARAMS
_MaskTex = { "Mask Tex", TEXTURE2D, "masktex" },
_LutTex = { "Lut Tex", TEXTURE2D, "luttex"},
_SenseHighTex = { "Sense High Tex", TEXTURE2D, "hightex"},
_Alpha = { "Alpha", FLOAT, "1.0"},
_Beta = { "Beta", FLOAT, "0.3"},
_BlendFirst = {"Blend First", FLOAT, "1.0"},
_BlendSecond = {"Blend Second", FLOAT, "1.0"},
_ShaderOne = {"Shader One", FLOAT, "1.0"},
_ShaderTwo = {"Shader Two", FLOAT, "1.0"},
_UseSenseTime = {"SenseTime", FLOAT, "1.0"},
_FinalShow = {"FinalShow", FLOAT, "1.0"},
_Brightscale = {"BrightScale", FLOAT, "2.0"},
_MaskPos = {"Mask Pos", VEC2, "300.0,708.0"},
_MaskScale = {"Mask Scale", FLOAT, "1.01"},
_HighPos = {"High Pos", VEC2, "223.0,602.0"},
_HighScale = {"High Scale", FLOAT, "1.0"}
#END

#DEFTAG
ShaderName = "LipStick"
RenderQueue = "Transparent+1"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "lipstick.inc"

struct appdata   
{
	float4 vertex : POSITION;
	float2 uv0 : TEXCOORD0;
	float2 uv1 : TEXCOORD1;
	float2 uv2 : TEXCOORD2;
};

struct v2f
{
	float2 uv0 : TEXCOORD0; 
	float2 uv1 : TEXCOORD1;  
	float2 uv2 : TEXCOORD2;  
	float4 vertex : SV_POSITION;
};

sampler2D _MainTex;
sampler2D _HighTex;
sampler2D _SenseHighTex;
sampler2D _MaskTex;
sampler2D _LutTex;
float _Brightscale;
float _Alpha;
float _Beta;
float _BlendFirst;
float _BlendSecond;
float _UseSenseTime;
float _ShaderOne;
float _ShaderTwo;
float2 _MaskPos;
float _MaskScale;
float2 _HighPos;
float _HighScale;
float _FinalShow;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = v.vertex;
    float4 facetexpara = float4(1.0/(167.0*_MaskScale),1.0/(122.0*_MaskScale),_MaskPos.x/(-167.0*_MaskScale),_MaskPos.y/(-122.0*_MaskScale));
    o.uv0 = v.uv0*facetexpara.xy+facetexpara.zw;
    float4 facehighpara =
    float4(1.0/(326.0*_HighScale),1.0/(326.0*_HighScale),_HighPos.x/(-326.0*_HighScale),_HighPos.y/(-326.0*_HighScale));
	o.uv2 = v.uv2*facehighpara.xy+facehighpara.zw;
	o.uv1 = float2(1.0+v.vertex.x,1.0-v.vertex.y)/2.0;
	return o;
}

float4 frag(v2f i) : SV_Target
{
	// sample the texture
	float4 basecolor = tex2D(_MainTex, i.uv1);
    float3 oricolor = basecolor.rgb;
	float4 blendcolor = tex2D(_MaskTex, i.uv0);
	float4 sensehigh = tex2D(_SenseHighTex, i.uv2);
	basecolor = float4(clampf3(basecolor.rgb,0.0,0.9),basecolor.a);

	int blendfirst = int(_BlendFirst);  
    int blendsecond = int(_BlendSecond);
    int sensetime = int(_UseSenseTime);  
    int shaderone = int(_ShaderOne);
    int shadertwo = int(_ShaderTwo);  


    float4 newcolor;
    if(shaderone == 1) //lut或者mask直接着色
    {
    	newcolor = LUT_mini(basecolor,_LutTex);
    }
    else
    {
    	newcolor = blendcolor;
    }
    newcolor.rgb = Blend_First(basecolor.rgb,newcolor.rgb,blendfirst);//第一次混合
    basecolor.rgb = blendcolor.a*_Beta*newcolor.rgb + (1.0-blendcolor.a*_Beta)*basecolor.rgb;//过滤作用 以及_Beta用来达到水润效果
    basecolor.rgb = basecolor.rgb*_Alpha+(1.0-_Alpha)*oricolor;//滑动条

   


    float3 hightlightcolor = tex2D(_HighTex, float2(i.uv1.x,1.0-i.uv1.y)).rgb;
    float4 outcolor;
    if(shadertwo == 1)
    {
    	if(sensetime == 2)
    	{
    		hightlightcolor = hightlightcolor*sensehigh.rgb;
    	}
    	float3 newcolor2 = Blend_Second(basecolor.rgb,hightlightcolor,blendsecond);//第二次混合
        newcolor2 = blendcolor.a*newcolor2+(1.0-blendcolor.a)*basecolor.rgb;//mask过滤 假设所有混合模式都用到了
        if(blendsecond == 1)
        { 
            float highlightblue = _Brightscale*hightlightcolor.b;
            newcolor2 = float3(1.0) - (float3(1.0) - newcolor2) * float3(1.0 - highlightblue);
        }
        outcolor = float4(newcolor2,1.0);
    }
    else
    {
    	outcolor = float4(basecolor.rgb,1.0);
    }

    if(_FinalShow == 1)
    {
        return outcolor;
    }
    else if(_FinalShow == 2)
    {
        return float4(basecolor.rgb,1.0);
    }
    else if(_FinalShow == 3)
    {
        return float4(hightlightcolor*blendcolor.a+oricolor*(1.0-blendcolor.a),1.0);
    }
    else if(_FinalShow == 4)
    {
        return float4(blendcolor.rgb*blendcolor.a+oricolor*(1.0-blendcolor.a),1.0);
    }

    
}
ENDCG
#END
