

#ifndef LIPSTICK3LAYER_INC
#define LIPSTICK3LAYER_INC

fixed4 LUT_mini(fixed4 textureColor, sampler2D lookupTable) 
{
    half blueColor = textureColor.b * 15.0;

    half2 quad1;
    quad1.y = floor(floor(blueColor) / 4.0);
    quad1.x = floor(blueColor) - (quad1.y * 4.0);

    half2 quad2;
    quad2.y = floor(ceil(blueColor) / 4.0);
    quad2.x = ceil(blueColor) - (quad2.y * 4.0);

    half2 texPos1;
    texPos1.x = (quad1.x * 0.25) + 0.0078125 + (0.234375 * textureColor.r);
    texPos1.y = (quad1.y * 0.25) + 0.0078125 + (0.234375 * textureColor.g);


    half2 texPos2;
    texPos2.x = (quad2.x * 0.25) + 0.0078125 + (0.234375 * textureColor.r);
    texPos2.y = (quad2.y * 0.25) + 0.0078125 + (0.234375 * textureColor.g);

    fixed4 newColor1 = tex2D(lookupTable, half2(texPos1.x,1.0-texPos1.y));
    fixed4 newColor2 = tex2D(lookupTable, half2(texPos2.x,1.0-texPos2.y));

    fixed4 newColor =  newColor1*(1.0-frac(blueColor))+newColor2*frac(blueColor);
    return newColor;
}

float Color_Burn(fixed base, fixed blend) {
  return (blend==0.0)?blend:max((1.0-((1.0-base)/blend)),0.0);
}

fixed3 Blend_First(fixed3 base, fixed3 blend, half mode) 
{
  fixed3 dst = step(mode, 1.5)*blend + step(1.5, mode)*(step(mode, 2.5)*base*blend + step(2.5, mode)*fixed3(Color_Burn(base.r,blend.r),Color_Burn(base.g,blend.g),Color_Burn(base.b,blend.b)));
   
  return dst;
}

//--------------------------



fixed3 blendSoftLight3(fixed3 base, fixed3 blend)
{
  fixed3 dst = 2.0 * base * blend + base * base - 2.0 * base * base * blend;
  return dst;
}


fixed3 Blend_Second(fixed3 base, fixed3 blend, half mode) 
{
  fixed3 dst = step(mode, 1.5)*blendSoftLight3(base,blend) + step(1.5, mode)*blend;//mode 1为柔光 2为normal模式
  return dst;
}

//--------------------------

fixed3 blendOverlaylipsticks(fixed3 base,fixed3 blend)
{

  fixed dstr = step(base.r,0.5)* 2.0 * blend.g * base.r + step(0.5,base.r) *(1.0 - 2.0 * (1.0 - blend.g) * (1.0 - base.r));
  fixed dstg = step(base.g,0.5)* 2.0 * blend.g * base.g + step(0.5,base.g) *(1.0 - 2.0 * (1.0 - blend.g) * (1.0 - base.g));
  fixed dstb = step(base.b,0.5)* 2.0 * blend.g * base.b + step(0.5,base.b) *(1.0 - 2.0 * (1.0 - blend.g) * (1.0 - base.b));

  return fixed3(dstr, dstg, dstb);

}


fixed3 blendScreen3(fixed3 base, fixed3 blend)
{
  return 1.0-((1.0-base)*(1.0-blend));
}







#endif