

#ifndef LIPSTICK_INC
#define LIPSTICK_INC

float4 LUT_mini(float4 textureColor, sampler2D lookupTable) 
{
    float blueColor = textureColor.b * 15.0;

    float2 quad1;
    quad1.y = floor(floor(blueColor) / 4.0);
    quad1.x = floor(blueColor) - (quad1.y * 4.0);

    float2 quad2;
    quad2.y = floor(ceil(blueColor) / 4.0);
    quad2.x = ceil(blueColor) - (quad2.y * 4.0);

    float2 texPos1;
    texPos1.x = (quad1.x * 0.25) + 0.0078125 + (0.234375 * textureColor.r);
    texPos1.y = (quad1.y * 0.25) + 0.0078125 + (0.234375 * textureColor.g);


    float2 texPos2;
    texPos2.x = (quad2.x * 0.25) + 0.0078125 + (0.234375 * textureColor.r);
    texPos2.y = (quad2.y * 0.25) + 0.0078125 + (0.234375 * textureColor.g);

    float4 newColor1 = tex2D(lookupTable, float2(texPos1.x,1.0-texPos1.y));
    float4 newColor2 = tex2D(lookupTable, float2(texPos2.x,1.0-texPos2.y));

    float4 newColor =  newColor1*(1.0-frac(blueColor))+newColor2*frac(blueColor);
    return newColor;
}

float clampf(float src,float min,float max)
{
  float dst = src;
  if(dst < min)
  {
    dst = min;
  }
  else if(dst > max)
  {
    dst = max;
  }
  return dst;
}

float3 clampf3(float3 input,float a,float b)
{

  float3 dst = float3(clampf(input.r,a,b),clampf(input.g,a,b),clampf(input.b,a,b));
  return dst;
} 

float Color_Burn(float base,float blend)
{
	if(abs(blend) < 0.001)
	{
		return 0;
	}
	else
	{
		return 1.0-(1.0-base)/blend;
	}
}

float3 Blend_First(in float3 base,in float3 blend, int mode) 
{
  float3 dst;
  if(mode == 1)
  {
    dst = blend;
  }
  else if(mode == 2)
  {
    dst = base * blend;
  }
  else if(mode == 3)
  {
    dst = float3(Color_Burn(base.r,blend.r),Color_Burn(base.g,blend.g),Color_Burn(base.b,blend.b));
  }
  return dst;
}


float3 blendOverlaylipsticks(float3 base,float3 hightlightcolor)
{
	float3 basecolor = base;
	if (basecolor.r < 0.5) {
      basecolor.r = 2.0 * hightlightcolor.g * basecolor.r;
    } 
    else {
      basecolor.r = 1.0 - 2.0 * (1.0 - hightlightcolor.g) * (1.0 - basecolor.r);
    }
    
    if (basecolor.g < 0.5) {
      basecolor.g = 2.0 * hightlightcolor.g * basecolor.g;
    } 
    else {
      basecolor.g = 1.0 - 2.0 * (1.0 - hightlightcolor.g) * (1.0 - basecolor.g);
    }
       
    if (basecolor.b < 0.5) {
      basecolor.b = 2.0 * hightlightcolor.g * basecolor.b;
    }
    else {
      basecolor.b = 1.0 - 2.0 * (1.0 - hightlightcolor.g) * (1.0 - basecolor.b);
    }
    
    return basecolor;
}

float blendScreen(float base, float blend) {
	return 1.0-((1.0-base)*(1.0-blend));
}

float3 blendScreen(float3 base, float3 blend) {
	return float3(blendScreen(base.r,blend.r),blendScreen(base.g,blend.g),blendScreen(base.b,blend.b));
}

float3 Blend_Second(in float3 base,in float3 blend, int mode) 
{
  float3 dst;
  if(mode == 1)
  {
    dst = blendOverlaylipsticks(base,blend);
  }
  else if(mode == 2)
  {
    dst = blendScreen(base,blend);
  }
  return dst;
}



#endif