

#include "commonvar.inc"

#ifndef COMMON_INC
#define COMMON_INC

#define SAMPLE_TEXCUBE_LOD(tex,coord,lod) texCUBElod(tex, half4(coord, lod))
#define SAMPLE_TEXCUBE(tex, coord) texCUBE(tex, coord)

#ifdef GPUSKIN4
    #define ANI_ATTRIBUTE float4 boneIndices:BLENDINDICES; float4 boneWeight:BLENDWEIGHT;
	                         
	#define COMPUTE_BONE_MATERIX(v) int boneIndex0 = int(v##.boneIndices.x) * 3;\
	                     int boneIndex1 = int(v##.boneIndices.y) * 3;\
						 int boneIndex2 = int(v##.boneIndices.z) * 3;\
						 int boneIndex3 = int(v##.boneIndices.w) * 3;\
						 float4x4 BONE_TRANSFROM;\
						 float4 row0;\
						 float4 row1;\
						 float4 row2;\
						 float4 row3;\
						 row0 = ANIMATION_MATRIX_ARRAY[boneIndex0] * v##.boneWeight.x;;\
						 row1 = ANIMATION_MATRIX_ARRAY[boneIndex0 + 1] * v##.boneWeight.x;\
						 row2 = ANIMATION_MATRIX_ARRAY[boneIndex0 + 2] * v##.boneWeight.x;\
						 row0 += ANIMATION_MATRIX_ARRAY[boneIndex1] * v##.boneWeight.y;\
						 row1 += ANIMATION_MATRIX_ARRAY[boneIndex1 + 1] * v##.boneWeight.y;\
						 row2 += ANIMATION_MATRIX_ARRAY[boneIndex1 + 2] * v##.boneWeight.y;\
						 row0 += ANIMATION_MATRIX_ARRAY[boneIndex2] * v##.boneWeight.z;\
						 row1 += ANIMATION_MATRIX_ARRAY[boneIndex2 + 1] * v##.boneWeight.z;\
						 row2 += ANIMATION_MATRIX_ARRAY[boneIndex2 + 2] * v##.boneWeight.z;\
						 row0 += ANIMATION_MATRIX_ARRAY[boneIndex3] * v##.boneWeight.w;\
						 row1 += ANIMATION_MATRIX_ARRAY[boneIndex3 + 1] * v##.boneWeight.w;\
						 row2 += ANIMATION_MATRIX_ARRAY[boneIndex3 + 2] * v##.boneWeight.w;\
						 row3 = float4(0.0, 0.0, 0.0, 1.0);\
						 BONE_TRANSFROM = float4x4(row0.x, row1.x, row2.x, 0.0,\
						                           row0.y, row1.y, row2.y, 0.0,\
												   row0.z, row1.z, row2.z, 0.0,\
												   row0.w, row1.w, row2.w, 1.0)

/*
#define COMPUTE_BONE_MATERIX(v) int boneIndex0 = int(v##.boneIndices.x) * 3;\
	                     int boneIndex1 = int(v##.boneIndices.y) * 3;\
						 int boneIndex2 = int(v##.boneIndices.z) * 3;\
						 int boneIndex3 = int(v##.boneIndices.w) * 3;\
						 float4x4 BONE_TRANSFROM;\
						 float4 row0;\
						 float4 row1;\
						 float4 row2;\
						 float4 row3;\
						 row0 = ANIMATION_MATRIX_ARRAY[boneIndex0] * v##.boneWeight.x;;\
						 row1 = ANIMATION_MATRIX_ARRAY[boneIndex0 + 1] * v##.boneWeight.x;\
						 row2 = ANIMATION_MATRIX_ARRAY[boneIndex0 + 2] * v##.boneWeight.x;\
						 BONE_TRANSFROM = float4x4(row0.x, row1.x, row2.x, 0.0,\
						                           row0.y, row1.y, row2.y, 0.0,\
												   row0.z, row1.z, row2.z, 0.0,\
												   row0.w, row1.w, row2.w, 1.0)
												   */


    #define ObjectToClipPos(pos4) mul(CAMERA_VIEWPROJ, mul(LOCALWORLD_TRANSFORM, mul(pos4, BONE_TRANSFROM)))
    #define WorldToClipPos(pos4) mul(CAMERA_VIEWPROJ, mul(pos4, BONE_TRANSFROM))
	#define ObjectToWorldNormal(normal) normalize(mul((float3x3)LOCALWORLD_TRANSFORM, mul(normal, (float3x3)BONE_TRANSFROM)))
	#define ObjectToWorldDir(dir) normalize(mul((float3x3)LOCALWORLD_TRANSFORM, mul(dir, (float3x3)BONE_TRANSFROM)))
	#define ObjectToWorldPos(pos4) mul(LOCALWORLD_TRANSFORM, mul(pos4, BONE_TRANSFROM))
	#define ObjectPos(pos4) mul(pos4, BONE_TRANSFROM)

#else
#define ANI_ATTRIBUTE
#define BONE_MATERIX
#define COMPUTE_BONE_MATERIX(v)

inline float4 ObjectToClipPos(in float3 pos)
{
    // More efficient than computing M*VP matrix product
    return mul(CAMERA_VIEWPROJ, mul(LOCALWORLD_TRANSFORM, float4(pos, 1.0)));
}

inline float4 WorldToClipPos(in float3 pos)
{
    return mul(CAMERA_VIEWPROJ, float4(pos, 1.0));
}

inline float3 ObjectToWorldNormal(float3 normal)
{
	return normalize(mul((float3x3)LOCALWORLD_TRANSFORM, normal));
}

inline float3 ObjectToWorldDir(float3 dir)
{
    return normalize(mul((float3x3)LOCALWORLD_TRANSFORM, dir));
}

inline float4 ObjectToWorldPos(in float3 pos)
{
	return mul(LOCALWORLD_TRANSFORM, float4(pos, 1.0));
}

inline float4 ObjectPos(in float3 pos)
{
	return float4(pos, 1.0);
}

#endif

inline float3 AmbientColor()
{
	return AMBIENT_COLOR.xyz;
}

inline float3 WorldViewDir(float3 worldPos)
{
	float3 worldViewDir = CAMERA_WORLDPOSITION.xyz - worldPos.xyz;
	worldViewDir.xyz = normalize(worldViewDir.xyz);
	return worldViewDir;
}

inline float3 WorldReflectionVector(float3 worldPos, float3 worldNormal)
{
	float3 worldViewDir = CAMERA_WORLDPOSITION.xyz - worldPos.xyz;
	worldViewDir.xyz = normalize(worldViewDir.xyz);
	float3 reflectDir = reflect(-worldViewDir.xyz, worldNormal.xyz);
	return reflectDir;
}

inline float4 UniformNDC(float4 vertex)
{
	float4 scale = float4(
		1.0f,
		DEVICE_COORDINATE_Y_FLIP,
		1.0f,
		1.0f
	);
	return mul(scale, vertex);
}

#endif
