

#ifndef BLENDMAKEUPFUNC_INC
#define BLENDMAKEUPFUNC_INC

//这是make_up美妆专用的公用的混合函数

//Normal
float3 blendNormal(float4 srcColor,float4 dstColor)
{
	float3 Fsrc = float3(srcColor.a,srcColor.a,srcColor.a);
	float sub_a = 1.0 - srcColor.a;
	float3 Fdst = float3(sub_a,sub_a,sub_a);
	return Fsrc * srcColor + Fdst * dstColor;
}
//Add
float3 blendAdd(float4 srcColor,float4 dstColor)
{
	float4 finColor;
	float4 Fsrc = float4(srcColor.a,srcColor.a,srcColor.a,srcColor.a);
	float4 Fdst = float4(1.0,1.0,1.0,1.0);
	finColor = Fsrc * srcColor + Fdst * dstColor;
	return finColor.rgb;
}
//Screen 公式:A or B ≤1? A+B-AB: max(A,B)，AB的颜色在shader中小于1
float3 blendScreen(float4 srcColor,float4 dstColor)
{
	float4 finColor;
	float4 Fsrc = float4(1.0,1.0,1.0,1.0);
	float4 Fdst = float4(1.0 - srcColor.r,1.0 - srcColor.g,1.0 - srcColor.b,1.0 - srcColor.a);
	finColor = Fsrc * srcColor + Fdst * dstColor;
	return finColor.rgb;
}
///Overlay
float blendOverlay(float srcColor,float dstColor)
{
	return dstColor < 0.5?(2.0 * srcColor * dstColor):(1.0 -2.0*(1.0-srcColor)*(1.0-dstColor));
}
float3 blendOverlay(float4 srcColor,float4 dstColor)
{
	return float3(blendOverlay(srcColor.r,dstColor.r),blendOverlay(srcColor.g,dstColor.g),blendOverlay(srcColor.b,dstColor.b));
}
float blendSoftlight(float srcColor,float dstColor)
{
	float a = dstColor;
	float b = srcColor;
	return a<0.5?(2.0*a*b+a*a*(1.0-2.0*b)):(2.0*a*(1.0-b)+sqrt(a)*(2.0*b-1.0));
}
//Softlight
float3 blendSoftlight(float4 srcColor,float4 dstColor)
{
	return float3(blendSoftlight(srcColor.r,dstColor.r),blendSoftlight(srcColor.g,dstColor.g),blendSoftlight(srcColor.b,dstColor.b));
}

//Lighten
float3 blendLighten(float4 srcColor,float4 dstColor)
{
	return float3(max(srcColor.r,dstColor.r),max(srcColor.g,dstColor.g),max(srcColor.b,dstColor.b));
}
//Multiply
float3 blendMultiply(float4 srcColor,float4 dstColor)
{
	return srcColor.rgb * dstColor.rgb;
}


float3 blendmakeup(int mode,float4 srcColor,float4 dstColor)
{
	if(mode == 1){
		return blendNormal(srcColor,dstColor);
	}else if(mode == 2){
		return blendAdd(srcColor,dstColor);
	}else if(mode == 3){
		return blendScreen(srcColor,dstColor) *srcColor.w + dstColor.rgb * (1.0 - srcColor.w);
	}else if(mode == 4){
		return blendOverlay(srcColor,dstColor)*srcColor.w + dstColor.rgb * (1.0 - srcColor.w);
	}else if(mode == 5){
		return blendSoftlight(srcColor,dstColor)*srcColor.w + dstColor.rgb * (1.0 - srcColor.w);
	}else if(mode == 6){
		return blendLighten(srcColor,dstColor)*srcColor.w + dstColor.rgb * (1.0 - srcColor.w);
	}else if(mode == 7){
		return blendMultiply(srcColor,dstColor)*srcColor.w + dstColor.rgb * (1.0 - srcColor.w);
	}
	return float3(1.0,0.0,0.0);
}

#endif