#SHADER_DEFINE QuadVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 		HIGH,	VEC4,	"in_Position" },
		{ ATTRIBUTE_COORDNATE0,     HIGH,   VEC2,   "in_TexCooridate"},
		{ LOCALWORLD_TRANSFORM, 	HIGH, 	MAT4, 	"in_WorldRotation"},
		{ WORLD_POSITION, 			HIGH, 	VEC3, 	"in_transpos"},
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,     HIGH,    VEC2,       "out_TexCooridate" },
	}

#SHADER_CODE
  gl_Position = in_Position * (1.0 / in_Position.w);
  gl_Position = gl_Position * in_WorldRotation;
  gl_Position.w = 1.0;
  gl_Position.x = gl_Position.x + in_transpos.x;
  gl_Position.y = gl_Position.y + in_transpos.y;
  vec2 out_TexCooridate =  in_TexCooridate ;
#END_CODE
#END_DEFINE

#SHADER_DEFINE QuadFragment

    FUNCTION_INPUT =
    {
        { TEXTURE_DIFFUSE,          NONE,    TEXTURE2D,  	"inputImageTexture" },
        { ATTRIBUTE_COORDNATE0,     HIGH,    VEC2,         	"textureCoordinate"},

    }

#SHADER_CODE
    gl_FragColor = texture2D(inputImageTexture,textureCoordinate);
#END_CODE
#END_DEFINE