

#DEFPARAMS
UNIFORM_BLUR_CENTER = { "BlurCenter", VEC2, "1.0, 1.0"},
UNIFORM_BLUR_SCALE = { "BlurScale", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "radialblur"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
  float4 vertex : POSITION;
  float2 uv : TEXCOORD0;
};

struct v2f
{
  float4 vertex : SV_POSITION;
  float2 uv : TEXCOORD0;
};

sampler2D TEXTURE_DIFFUSE;
float2 UNIFORM_BLUR_CENTER;
float UNIFORM_BLUR_SCALE;

v2f vert(appdata v)
{
  v2f o;
  o.vertex = UniformNDC(v.vertex);  
  o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
  float2 pos = UNIFORM_BLUR_CENTER - i.uv;
  float3 rgb = tex2D(TEXTURE_DIFFUSE,i.uv).rgb;
  rgb = tex2D(TEXTURE_DIFFUSE,i.uv + UNIFORM_BLUR_SCALE * pos).rgb + rgb;
  rgb = tex2D(TEXTURE_DIFFUSE,i.uv + UNIFORM_BLUR_SCALE * pos* 2.0).rgb + rgb;
  rgb = tex2D(TEXTURE_DIFFUSE,i.uv + UNIFORM_BLUR_SCALE * pos* 3.0).rgb + rgb;
  rgb = tex2D(TEXTURE_DIFFUSE,i.uv + UNIFORM_BLUR_SCALE * pos* 4.0).rgb + rgb;
  rgb = tex2D(TEXTURE_DIFFUSE,i.uv + UNIFORM_BLUR_SCALE * pos* 5.0).rgb + rgb;
  rgb = tex2D(TEXTURE_DIFFUSE,i.uv + UNIFORM_BLUR_SCALE * pos* 6.0).rgb + rgb;
  rgb = tex2D(TEXTURE_DIFFUSE,i.uv + UNIFORM_BLUR_SCALE * pos* 7.0).rgb + rgb;
  rgb = tex2D(TEXTURE_DIFFUSE,i.uv + UNIFORM_BLUR_SCALE * pos* 8.0).rgb + rgb;
  rgb = tex2D(TEXTURE_DIFFUSE,i.uv + UNIFORM_BLUR_SCALE * pos* 9.0).rgb + rgb;
  rgb = tex2D(TEXTURE_DIFFUSE,i.uv + UNIFORM_BLUR_SCALE * pos* 10.0).rgb + rgb;
  rgb = tex2D(TEXTURE_DIFFUSE,i.uv + UNIFORM_BLUR_SCALE * pos* 11.0).rgb + rgb;
  rgb = tex2D(TEXTURE_DIFFUSE,i.uv + UNIFORM_BLUR_SCALE * pos* 12.0).rgb + rgb;
  rgb = tex2D(TEXTURE_DIFFUSE,i.uv + UNIFORM_BLUR_SCALE * pos* 13.0).rgb + rgb;
  rgb = tex2D(TEXTURE_DIFFUSE,i.uv + UNIFORM_BLUR_SCALE * pos* 14.0).rgb + rgb;
  rgb = tex2D(TEXTURE_DIFFUSE,i.uv + UNIFORM_BLUR_SCALE * pos* 15.0).rgb + rgb;
  rgb = tex2D(TEXTURE_DIFFUSE,i.uv + UNIFORM_BLUR_SCALE * pos* 16.0).rgb + rgb;
  rgb = tex2D(TEXTURE_DIFFUSE,i.uv + UNIFORM_BLUR_SCALE * pos* 17.0).rgb + rgb;
  rgb = tex2D(TEXTURE_DIFFUSE,i.uv + UNIFORM_BLUR_SCALE * pos* 18.0).rgb + rgb;
  rgb = tex2D(TEXTURE_DIFFUSE,i.uv + UNIFORM_BLUR_SCALE * pos* 19.0).rgb + rgb;
  rgb = rgb / 20.0;
  return float4(rgb, 1.0);
}
ENDCG
#END
