

#DEFPARAMS
TEXTURE_DIFFUSE = { "tex", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "Skeleton3B"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 position : POSITION;
	float3 normal : NORMAL;
	float4 tangent : TANGENT;
	float3 binormal : BINORMAL;
	float2 uv : TEXCOORD0;
	float4 BoneIndex : BLENDINDICES;
	float4 Boneweight : BLENDWEIGHT;
};

struct v2f
{
	float4 position : SV_POSITION;
	float3 normal : WORLDSPACE_NORMAL;
	float3 tangent : WORLDSPACE_TANGENT;
	float3 binormal : WORLDSPACE_BINORMAL;
	float2 uv : TEXCOORD0;
	float4 index : BLENDINDICES;
	float4 weight : BLENDWEIGHT;
	float4 positionWS : WORLDSPACE_POSITION;
	float3 positionCS : CAMERASPACE_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
float3x3 LOCALWORLD_ROTATION;

v2f vert(appdata v)
{
	v2f o;

	o.uv = v.uv.xy;

	float3 blendPos = float3(0.0, 0.0, 0.0);
	float3 blendNorm = float3(0.0, 0.0, 0.0);
	float3 blendTangent = float3(0.0, 0.0, 0.0);

	for (int bone = 0; bone < 3; ++bone)
	{
		int idx = int(v.BoneIndex[bone]) * 3;

		float weight = v.Boneweight[bone];

		float4x4 worldMatrix =
		{
			ANIMATION_MATRIX_ARRAY[idx],
			ANIMATION_MATRIX_ARRAY[idx + 1],
			ANIMATION_MATRIX_ARRAY[idx + 2],
			float4(0.0)
		};

		blendPos += mul(worldMatrix, v.position).xyz * weight;

		float3x3 worldRotMtrix = float3x3(worldMatrix[0].xyz,worldMatrix[1].xyz,worldMatrix[2].xyz);
		blendNorm += mul(worldRotMtrix, v.normal.xyz) * weight;

		blendTangent += mul(worldRotMtrix, v.tangent.xyz) * weight;
	}

	blendNorm = normalize(blendNorm);

	o.position = float4(blendPos,1.0);
	o.normal = blendNorm;
	o.tangent = blendTangent;
	o.binormal = v.binormal;


	o.normal = mul(LOCALWORLD_ROTATION, o.normal.xyz);
	o.tangent =  mul(LOCALWORLD_ROTATION, o.tangent.xyz);
	o.binormal = mul(LOCALWORLD_ROTATION, o.binormal.xyz);
	o.positionWS = mul(LOCALWORLD_TRANSFORM, o.position);
	float4 positionCS = mul(CAMERA_VIEW, o.positionWS);
	o.positionCS = positionCS.xyz / positionCS.w;
	o.position = mul(CAMERA_VIEWPROJ, o.positionWS);
	o.position = UniformNDC(o.position);

	return o;
}

float4 frag(v2f i) : SV_Target
{
	return tex2D(TEXTURE_DIFFUSE, i.uv);
}
ENDCG
#END
