

#DEFPARAMS
TEXTURE_DIFFUSE = { "tex", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "Skeleton3B"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGB
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 position : POSITION;
	float3 normal : NORMAL;
	float4 tangent : TANGENT;
	float3 binormal : BINORMAL;
	float2 uv : TEXCOORD0;
	float4 BoneIndex : BLENDINDICES;
	float4 Boneweight : BLENDWEIGHT;
};

struct v2f
{
	float4 position : SV_POSITION;
	float3 normal : WORLDSPACE_NORMAL;
	float3 tangent : WORLDSPACE_TANGENT;
	float3 binormal : WORLDSPACE_BINORMAL;
	float2 uv : TEXCOORD0;
	float4 index : BLENDINDICES;
	float4 weight : BLENDWEIGHT;
	float4 positionWS : WORLDSPACE_POSITION;
	float3 positionCS : CAMERASPACE_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
float4 ANIMATION_REAL_ARRAY[50];
float4 ANIMATION_DUAL_ARRAY[50];
float3x3 LOCALWORLD_ROTATION;

v2f vert(appdata v)
{
	v2f o;

	o.uv = v.uv.xy;

	int4 BoneIndices;
	BoneIndices.x = int(v.BoneIndex.x);
	BoneIndices.y = int(v.BoneIndex.y);
	BoneIndices.z = int(v.BoneIndex.z);
	BoneIndices.a = int(v.BoneIndex.a);
	
	float4 dp0 = ANIMATION_REAL_ARRAY[ BoneIndices[0] ];	
	float4 blend_real = float4(0,0,0,0);
	float4 blend_dual = float4(0,0,0,0);
	for (int i = 0; i < 3; ++ i)
	{
		float4 joint_real = ANIMATION_REAL_ARRAY[BoneIndices[i]];
		float4 joint_dual = ANIMATION_DUAL_ARRAY[BoneIndices[i]];

		if (dot(dp0,joint_real) < 0.0)
		{
			joint_real = -joint_real;
			joint_dual = -joint_dual;
		}
	
		float weight = v.Boneweight[i];

		blend_real += joint_real * weight;
		blend_dual += joint_dual * weight;
	}

	float inv_len = 1.0 / length(blend_real);
	blend_real *= inv_len;
	blend_dual *= inv_len;
	
	float3 pos = v.position.xyz + 2.0 * cross(blend_real.xyz, cross(blend_real.xyz, v.position.xyz) + blend_real.w * v.position.xyz);
	float3 trans = 2.0 * (blend_real.w * blend_dual.xyz - blend_dual.w * blend_real.xyz + cross(blend_real.xyz, blend_dual.xyz));
	pos += trans;

	o.normal = v.normal.xyz + 2.0 * cross(blend_real.xyz, cross(blend_real.xyz, v.normal.xyz) + blend_real.w * v.normal.xyz);
	o.tangent = v.tangent.xyz + 2.0 * cross(blend_real.xyz, cross(blend_real.xyz, v.tangent.xyz) + blend_real.w * v.tangent.xyz);	
	o.tangent *= v.tangent.w;
	o.binormal = v.binormal;
	o.position = float4( pos, v.position.w );
	o.weight = v.Boneweight;
	o.index = v.BoneIndex;


	o.normal = mul(LOCALWORLD_ROTATION, o.normal.xyz);
	o.tangent =  mul(LOCALWORLD_ROTATION, o.tangent.xyz);
	o.binormal = mul(LOCALWORLD_ROTATION, o.binormal.xyz);
	o.positionWS = mul(LOCALWORLD_TRANSFORM, o.position);
	float4 positionCS = mul(CAMERA_VIEW, o.positionWS);
	o.positionCS = positionCS.xyz / positionCS.w;
	o.position = mul(CAMERA_VIEWPROJ, o.positionWS);
	o.position = UniformNDC(o.position);

	return o;
}

float4 frag(v2f i) : SV_Target
{
	return tex2D(TEXTURE_DIFFUSE, i.uv);
}
ENDCG
#END
