#DEFPARAMS
TEXTURE_DIFFUSE = {"TEXTURE_DIFFUSE", TEXTURE2D, "white" },
TEXTURE_NEIGHBOR_BLEND = {"TEXTURE_NEIGHBOR_BLEND", TEXTURE2D, "white" },
PIXEL_SIZE = {"PIXEL_SIZE", VEC2, "0.0,0.0"},
#END

#DEFTAG
ShaderName = "NeighborBlend"
RenderQueue = "POSTEFFECT"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
#include "functions/mlaa.function"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{ 
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
sampler2D TEXTURE_NEIGHBOR_BLEND;
float2 PIXEL_SIZE;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv;

	return o;
}

float4 frag(v2f i) : SV_Target
{
    float2 textureCoordinate = i.uv;
    float2 texcoord = textureCoordinate;
    float4 topLeft = tex2D(TEXTURE_NEIGHBOR_BLEND,texcoord).rgba;
    float4 out_SurfaceColor = float4(0.0,0.0,0.0,0.0);
    float2 PIXEL_SIZE = float2(1.0/544.0,1.0/960.0);
    PIXEL_SIZE = PIXEL_SIZE;  
    float yInverse = -1.0;
    float bottom = tex2D(TEXTURE_NEIGHBOR_BLEND,texcoord+float2(0.0,1.0*yInverse)*PIXEL_SIZE).g;
    float  right= tex2D(TEXTURE_NEIGHBOR_BLEND,texcoord+float2(1.0,0.0)*PIXEL_SIZE).a;
    float4 a = float4(topLeft.r, right, topLeft.b, bottom);
    float sum = dot(a, float4(1.0,1.0,1.0,1.0));
    if (sum > 0.0) 
    {
    
      float4 o = a * float4(PIXEL_SIZE.y,PIXEL_SIZE.y,PIXEL_SIZE.x,PIXEL_SIZE.x);
      float4 color = float4(0.0,0.0,0.0,0.0);
      color = mad((tex2D(TEXTURE_DIFFUSE,texcoord + float2( 0.0, -o.r*yInverse))), pow(float4(a.r,a.r,a.r,a.r),float4(1.0)), color);
      color = mad((tex2D(TEXTURE_DIFFUSE,texcoord + float2( 0.0, o.g*yInverse))), pow(float4(a.g,a.g,a.g,a.g),float4(1.0)), color);
      color = mad((tex2D(TEXTURE_DIFFUSE,texcoord + float2( -o.b, 0.0))), pow(float4(a.b,a.b,a.b,a.b),float4(1.0)), color);
      color = mad((tex2D(TEXTURE_DIFFUSE,texcoord + float2( o.a, 0.0))), pow(float4(a.a,a.a,a.a,a.a),float4(1.0)), color);
      out_SurfaceColor = color / sum;
      out_SurfaceColor.a = 1.0;
      out_SurfaceColor = encodegamma(out_SurfaceColor);
    } 
    else 
    {
        out_SurfaceColor =  encodegamma(float4(tex2D(TEXTURE_DIFFUSE,textureCoordinate).rgb,1.0));     
    }
    return out_SurfaceColor;
}
ENDCG
#END