

#DEFPARAMS

#END

#DEFTAG
ShaderName = "LightingOnly"
RenderQueue = "Opaque+100"
#END

#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdbase
#include "lightlambert.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	ANI_ATTRIBUTE
};

struct v2f
{
	float3 worldpos : TEXCOORD2;
	float3 worldnormal : TEXCOORD3;
	float4 vertex : SV_POSITION;
	SHADOW_COORDS(4)
};


v2f vert(appdata v)
{
	COMPUTE_BONE_MATERIX(v);

	v2f o;
	o.vertex = ObjectToClipPos(v.vertex);
	o.worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldpos = UniformNDC(o.worldpos);

	o.worldnormal = ObjectToWorldNormal(v.normal).xyz;

	TRANSFER_SHADOW(o, v.vertex);
	return o;
}

float4 frag(v2f i) : SV_Target
{
	// sample the texture
	SurfaceInput input;
	input.albedo = float4(1,1,1,1);
	input.worldNormal = normalize(i.worldnormal.xyz);
	input.worldPos = i.worldpos;
	input.emission = AmbientColor();
	input.atten = SHADOW_ATTEN(i);

	float4 outColor;
	outColor.xyz = LightCalc(input);
	outColor.w = 1.0;
	return outColor;
}
ENDCG
#END

#DEFPASS ForwardAdd
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, ONE, ONE, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDADD }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdadd
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;

	ANI_ATTRIBUTE
};

struct v2f
{
	float3 worldpos : TEXCOORD2;
	float3 worldnormal : TEXCOORD3;
	float4 vertex : SV_POSITION;
	SHADOW_COORDS(4)
};



v2f vert(appdata v)
{
	COMPUTE_BONE_MATERIX(v);

	v2f o;
	o.vertex = ObjectToClipPos(v.vertex);
	o.worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldpos = UniformNDC(o.worldpos);
	o.worldnormal = ObjectToWorldNormal(v.normal).xyz;

	TRANSFER_SHADOW(o, v.vertex);
	return o;
}

float4 frag(v2f i) : SV_Target
{
	// sample the texture
	SurfaceInput input;
	input.albedo = float4(1,1,1,1);
	input.worldNormal = normalize(i.worldnormal.xyz);
	input.worldPos = i.worldpos;
	input.emission = float3(0.0, 0.0, 0.0);
	input.atten = SHADOW_ATTEN(i);

	float4 outColor;
	outColor.xyz = LightCalc(input);
	outColor.w = 1.0;
	return outColor;
}
ENDCG

#END

#DEFPASS Depth
	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	CGPROGRAM
	#pragma vertex vert
	#pragma fragment frag
	#include "light.inc"

	struct appdata
	{
		float4 vertex : POSITION;
		float3 normal : NORMAL;
		ANI_ATTRIBUTE
	};

	struct v2f
	{
		float4 vertex : SV_POSITION;
	};

	v2f vert(appdata v)
	{
		COMPUTE_BONE_MATERIX(v);
		float4 clipPos = ObjectToClipPos(v.vertex);
		clipPos = UniformNDC(clipPos);
		clipPos = ApplyShadowBias(clipPos);

		v2f o;
		o.vertex = clipPos;
		return o;
	}

	float4 frag(v2f i) : SV_Target
	{
		return float4(0.0, 0.0, 0.0, 1.0);
	}
	ENDCG
#END
