

#DEFPARAMS
#END

#DEFTAG
ShaderName = "Invert"
RenderQueue = "LaplaceSharp"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
	//float2 laplaceCoord[9];
};

sampler2D TEXTURE_DIFFUSE;
float2 TARGETSIZE;
float SHARPEN_STRENGTH;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
	float2 laplaceCoord[9];
	float3 d = float3(1.0, -1.0, 0.0);
	float2 invSize = 1.0 / TARGETSIZE;
	laplaceCoord[0] = i.uv + d.yy * invSize;
	laplaceCoord[1] = i.uv + d.zy * invSize;
	laplaceCoord[2] = i.uv + d.xy * invSize;
	laplaceCoord[3] = i.uv + d.yz * invSize;
	laplaceCoord[4] = i.uv + d.zz * invSize;
	laplaceCoord[5] = i.uv + d.xz * invSize;
	laplaceCoord[6] = i.uv + d.yx * invSize;
	laplaceCoord[7] = i.uv + d.zx * invSize;
	laplaceCoord[8] = i.uv + d.xx * invSize;

	float scaleFactor = SHARPEN_STRENGTH;

	float kernelValue0 = 0.0; 
	float kernelValue1 = -1.0; 
	float kernelValue2 = 0.0;
	float kernelValue3 = -1.0; 
	float kernelValue4 = 4.0; 
	float kernelValue5 = -1.0;
	float kernelValue6 = 0.0; 
	float kernelValue7 = -1.0; 
	float kernelValue8 = 0.0;

	float4 cTemp0,cTemp1,cTemp2,cTemp3,cTemp4,cTemp5,cTemp6,cTemp7,cTemp8;
	cTemp0 = tex2D(TEXTURE_DIFFUSE, laplaceCoord[0]);
	cTemp1 = tex2D(TEXTURE_DIFFUSE, laplaceCoord[1]);
	cTemp2 = tex2D(TEXTURE_DIFFUSE, laplaceCoord[2]);
	cTemp3 = tex2D(TEXTURE_DIFFUSE, laplaceCoord[3]);
	cTemp4 = tex2D(TEXTURE_DIFFUSE, laplaceCoord[4]);
	cTemp5 = tex2D(TEXTURE_DIFFUSE, laplaceCoord[5]);
	cTemp6 = tex2D(TEXTURE_DIFFUSE, laplaceCoord[6]);
	cTemp7 = tex2D(TEXTURE_DIFFUSE, laplaceCoord[7]);
	cTemp8 = tex2D(TEXTURE_DIFFUSE, laplaceCoord[8]);

	float4 sum = kernelValue0*cTemp0 + kernelValue1*cTemp1 + kernelValue2*cTemp2 +
	kernelValue3*cTemp3 + kernelValue4*cTemp4 + kernelValue5*cTemp5+
	kernelValue6*cTemp6 + kernelValue7*cTemp7 + kernelValue8*cTemp8;

	return cTemp4 + sum * scaleFactor;
}
ENDCG
#END
