

#DEFPARAMS
GAUSSIAN_STEP = { "GaussianStep", VEC2, "5.0,5.0" },
#END

#DEFTAG
ShaderName = "GaussianBlurBeauty"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
float2 GAUSSIAN_STEP;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;


	return o;
}

float4 frag(v2f i) : SV_Target
{
	float2 gaussianCoord[5];
	float2 inCoord = i.uv;
	float2 step = GAUSSIAN_STEP;
	float2 step2 = step + step;

	gaussianCoord[0] = inCoord;
	gaussianCoord[1] = inCoord - step;
	gaussianCoord[2] = inCoord + step;
	gaussianCoord[3] = inCoord - step2;
	gaussianCoord[4] = inCoord + step2;

	float Weight[5];
	Weight[0] = 0.4;
	Weight[1] = Weight[2] = 0.2;
	Weight[3] = Weight[4] = 0.1;

	float3 color;
	color =  Weight[0] * tex2D(TEXTURE_DIFFUSE, gaussianCoord[0]).rgb;
	color += Weight[1] * tex2D(TEXTURE_DIFFUSE, gaussianCoord[1]).rgb;
	color += Weight[2] * tex2D(TEXTURE_DIFFUSE, gaussianCoord[2]).rgb;
	color += Weight[3] * tex2D(TEXTURE_DIFFUSE, gaussianCoord[3]).rgb;
	color += Weight[4] * tex2D(TEXTURE_DIFFUSE, gaussianCoord[4]).rgb;

	return float4(color, 1.0);
}
ENDCG
#END
