

#DEFPARAMS
#END

#DEFTAG
ShaderName = "FXAA"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
float FXAA_REDUCE_MIN;
float FXAA_REDUCE_MUL;
float FXAA_SPAN_MAX;
float2 PIXEL_OFFSETS;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
	//optimized version for mobile, where dependent 
	//texture reads can be a bottleneck
    float2 v_rgbNW = i.uv + float2(-1.0, -1.0) * PIXEL_OFFSETS;
	float2 v_rgbNE = i.uv + float2(1.0, -1.0) * PIXEL_OFFSETS;
	float2 v_rgbSW = i.uv + float2(-1.0, 1.0) * PIXEL_OFFSETS;
	float2 v_rgbSE = i.uv + float2(1.0, 1.0) * PIXEL_OFFSETS;
	float2 v_rgbM = float2(i.uv);
    float3 rgbNW = tex2D(TEXTURE_DIFFUSE, v_rgbNW).xyz;
    float3 rgbNE = tex2D(TEXTURE_DIFFUSE, v_rgbNE).xyz;
    float3 rgbSW = tex2D(TEXTURE_DIFFUSE, v_rgbSW).xyz;
    float3 rgbSE = tex2D(TEXTURE_DIFFUSE, v_rgbSE).xyz;
    float4 texColor = tex2D(TEXTURE_DIFFUSE, v_rgbM);
    float3 rgbM  = texColor.xyz;
    float3 luma = float3(0.299, 0.587, 0.114);
    float lumaNW = dot(rgbNW, luma);
    float lumaNE = dot(rgbNE, luma);
    float lumaSW = dot(rgbSW, luma);
    float lumaSE = dot(rgbSE, luma);
    float lumaM  = dot(rgbM,  luma);
    float lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));
    float lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));
    
    float2 dir;
    dir.x = -((lumaNW + lumaNE) - (lumaSW + lumaSE));
    dir.y =  ((lumaNW + lumaSW) - (lumaNE + lumaSE));
    
    float dirReduce = max((lumaNW + lumaNE + lumaSW + lumaSE) *
                          (0.25 * FXAA_REDUCE_MUL), FXAA_REDUCE_MIN);
    
    float rcpDirMin = 1.0 / (min(abs(dir.x), abs(dir.y)) + dirReduce);
    dir = min(float2(FXAA_SPAN_MAX, FXAA_SPAN_MAX),
              max(float2(-FXAA_SPAN_MAX, -FXAA_SPAN_MAX),
              dir * rcpDirMin)) * PIXEL_OFFSETS;
    
    float3 rgbA = 0.5 * (
        tex2D(TEXTURE_DIFFUSE, i.uv  + dir * (1.0 / 3.0 - 0.5)).xyz +
        tex2D(TEXTURE_DIFFUSE, i.uv  + dir * (2.0 / 3.0 - 0.5)).xyz);
    float3 rgbB = rgbA * 0.5 + 0.25 * (
        tex2D(TEXTURE_DIFFUSE, i.uv  + dir * -0.5).xyz +
        tex2D(TEXTURE_DIFFUSE, i.uv  + dir * 0.5).xyz);

    float lumaB = dot(rgbB, luma);
    //if ((lumaB < lumaMin) || (lumaB > lumaMax))
    //    gl_FragColor = float4(rgbA, texColor.a);
    //else
    //    gl_FragColor = float4(rgbB, texColor.a);
    return step(lumaMin,lumaB)*step(lumaB,lumaMax)*float4(rgbB, texColor.a)+(1.0-step(lumaMin,lumaB)*step(lumaB,lumaMax))*float4(rgbA, texColor.a);
}
ENDCG
#END
