#DEFPARAMS
TEXTURE_DIFFUSE = {"TEXTURE_DIFFUSE", TEXTURE2D, "white" },
PIXEL_SIZE = {"PIXEL_SIZE", VEC2, "0.0,0.0"},
#END

#DEFTAG
ShaderName = "EdgeDetection"
RenderQueue = "POSTEFFECT"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
#include "functions/mlaa.function"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{ 
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
float2 PIXEL_SIZE;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv;

	return o;
}

float4 frag(v2f i) : SV_Target
{
  float3 weights = float3(0.2126,0.7152, 0.0722);
  float2 texcoord = i.uv;
  float2 steppixel =float2(1.0/544.0,1.0/960.0);
  steppixel = PIXEL_SIZE;
  float yInvese = -1.0;
  float L = dot((tex2D(TEXTURE_DIFFUSE,texcoord).rgb), weights);
  float Lleft = dot((tex2D(TEXTURE_DIFFUSE,texcoord-float2(1.0,0.0)*steppixel).rgb), weights);
  float Ltop = dot((tex2D(TEXTURE_DIFFUSE,texcoord-float2(0.0,1.0)*steppixel*yInvese).rgb), weights);
  float Lright = dot((tex2D(TEXTURE_DIFFUSE,texcoord+float2(1.0,0.0)*steppixel).rgb), weights);
  float Lbottom = dot((tex2D(TEXTURE_DIFFUSE,texcoord+float2(0.0,1.0)*steppixel*yInvese).rgb), weights);
  float threshold =0.1;
  float4 delta = abs(sqrt(float4(L)) - sqrt(float4(Lleft, Ltop, Lright, Lbottom)));
  float4 edges = step(float4(threshold), delta);
  edges.b=0.0;
  float4 out_SurfaceColor = edges;
  return out_SurfaceColor;
} 
ENDCG
#END