

#DEFPARAMS
#END

#DEFTAG
ShaderName = "Combine"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
sampler2D TEXTURE_GLOSSINESS;
float2 COMBINE_WEIRHT;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
	float4 Color_Ori = tex2D(TEXTURE_DIFFUSE, i.uv);
	float4 Color_Glo = tex2D(TEXTURE_GLOSSINESS, i.uv);
	float4 out_TextureColor = float4( Color_Ori.xyz*COMBINE_WEIRHT.x + Color_Glo.xyz*COMBINE_WEIRHT.y, Color_Ori.a ) ;
	return out_TextureColor;
}
ENDCG
#END
