

#DEFPARAMS
#END

#DEFTAG
ShaderName = "BrightenOverlay"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
sampler2D TEXTURE_BLEND;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
    float3 w = float3(0.2125,0.7154,0.0721);
    float3 basecolor = tex2D(TEXTURE_DIFFUSE, i.uv).rgb;
    float3 blendcolor = tex2D(TEXTURE_BLEND,  i.uv).rgb;
    float l = dot(basecolor,w);
    float3 rgb = (l < 0.5)? (2.0 * basecolor * blendcolor) : (float3(1.0) - 2.0*(float3(1.0) - basecolor)*(float3(1.0) - blendcolor));
    return float4(rgb, 1.0);
}
ENDCG
#END

#DEFTAG
ShaderName = "BrightenOverlay"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
sampler2D TEXTURE_BLEND;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
    float3 w = float3(0.2125,0.7154,0.0721);
    float3 basecolor = tex2D(TEXTURE_DIFFUSE, i.uv).rgb;
    float3 blendcolor = tex2D(TEXTURE_BLEND,  i.uv).rgb;
    float l = dot(basecolor,w);
    float3 rgb = (l < 0.5)? (2.0 * basecolor * blendcolor) : (float3(1.0) - 2.0*(float3(1.0) - basecolor)*(float3(1.0) - blendcolor));
    return float4(rgb, 1.0);
}
ENDCG
#END