#DEFPARAMS
TEXTURE_DIFFUSE = {"TEXTURE_DIFFUSE", TEXTURE2D, "white" },
TEXTURE_DIFFUSE_POINT = {"TEXTURE_DIFFUSE_POINT", TEXTURE2D, "white" },
TEXTURE_AREAMAP = {"TEXTURE_AREAMAP", TEXTURE2D, "white" },
PIXEL_SIZE = {"PIXEL_SIZE", VEC2, "0.0,0.0"}
#END

#DEFTAG
ShaderName = "BlendWeight"
RenderQueue = "POSTEFFECT"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
#include "functions/mlaa.function"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
sampler2D TEXTURE_DIFFUSE_POINT;
sampler2D TEXTURE_AREAMAP;
float2 PIXEL_SIZE;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv;

	return o;
}

float4 frag(v2f i) : SV_Target
{
    float2 textureCoordinate = i.uv;
    float4 out_SurfaceColor = float4(0.0,0.0,0.0,1.0);
  float4 weights = float4(0.0,0.0,0.0,0.0);
  float2 e = tex2D(TEXTURE_DIFFUSE_POINT,textureCoordinate).rg;
  float2 texcoord = textureCoordinate;
 
  int searchSteps = int(mlaa_searchsteps);
  float NUM_DISTANCES = 32.0;
  float yInverse = -1.0;
  
  if(e.g>0.9)
  {
   float2 d = float2(SearchXLeft(textureCoordinate,TEXTURE_DIFFUSE,PIXEL_SIZE,searchSteps), SearchXRight(textureCoordinate,TEXTURE_DIFFUSE,PIXEL_SIZE,searchSteps));
   float4 coords = float4(d.x, -0.25*yInverse, d.y + 1.0, -0.25*yInverse)*float4(PIXEL_SIZE.xy,PIXEL_SIZE.xy)+float4(texcoord.xy,texcoord.xy);
   float e1 = tex2D(TEXTURE_DIFFUSE,coords.xy).r;
   float e2 = tex2D(TEXTURE_DIFFUSE,coords.zw).r;
   weights.rg = Area(abs(d), e1, e2,NUM_DISTANCES,TEXTURE_AREAMAP);
   
  }



    if (e.r>0.9)
    {
        float2 d = float2(SearchYUp2(textureCoordinate,TEXTURE_DIFFUSE,PIXEL_SIZE,searchSteps), SearchYDown2(textureCoordinate,TEXTURE_DIFFUSE,PIXEL_SIZE,searchSteps));
           //float2 d = float2(SearchYDown(textureCoordinate,TEXTURE_DIFFUSE,PIXEL_SIZE,searchSteps), SearchYUp(textureCoordinate,TEXTURE_DIFFUSE,PIXEL_SIZE,searchSteps));
        float4 coords = float4(-0.25, d.x*yInverse, -0.25, (d.y + 1.0)*yInverse)*float4(PIXEL_SIZE.xy,PIXEL_SIZE.xy)+float4(texcoord.xy,texcoord.xy);
        
      float e1 = tex2D(TEXTURE_DIFFUSE,coords.xy).g;
      float e2 = tex2D(TEXTURE_DIFFUSE,coords.zw).g;
      weights.ba = Area(abs(d), e1, e2,NUM_DISTANCES,TEXTURE_AREAMAP);

    }

    out_SurfaceColor = float4(weights.rg,weights.ba);
    return out_SurfaceColor;
}
 
ENDCG
#END