

#DEFPARAMS
TEXTURE_DIFFUSE = {"Main Color", TEXTURE2D, "white" },
TEXTURE_BLEND = {"Blend Color", TEXTURE2D, "white"},
#END

#DEFTAG
ShaderName = "BlendAdd"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_DIFFUSE;
sampler2D TEXTURE_BLEND;

v2f vert(appdata v)
{
    v2f o;
    o.vertex = UniformNDC(v.vertex);
    o.uv = v.uv.xy;

    return o;
}

float4 frag(v2f i) : SV_Target
{
    float3 basecolor = tex2D(TEXTURE_DIFFUSE, i.uv).rgb;
    float3 blendcolor = tex2D(TEXTURE_BLEND, i.uv).rgb;
    float3 rgb = float3(
        min(1.0, basecolor.r + blendcolor.r),
        min(1.0, basecolor.g + blendcolor.g),
        min(1.0, basecolor.b + blendcolor.b)
    );
    return float4(rgb, 1.0);
}
ENDCG
#END
