

#DEFPARAMS
TEXTURE_EYEMASK =  { "TextureEyeMask",  TEXTURE2D, "white" },
UNIFORM_STRENGTH = { "Stength", FLOAT, "0.0" },
#END

#DEFTAG
ShaderName = "BlackEyesCircles"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_SPECULAR;
sampler2D TEXTURE_ORIGIN;
sampler2D TEXTURE_EYEMASK;
float UNIFORM_STRENGTH;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
    float3 sourceColor = tex2D(TEXTURE_ORIGIN, i.uv).rgb;
    float3 mask = tex2D(TEXTURE_EYEMASK, i.uv).r;
    float3 blurColor2 = tex2D(TEXTURE_SPECULAR, i.uv).rgb;
   
    // 放大差值，用输入的图像加上差值，消除差值所带来的影响
    float3 diffColor = clamp((blurColor2 - sourceColor) * 1.2 + 0.03 * blurColor2, 0.0, 0.3);
    float3 color = mix(sourceColor, min(sourceColor + diffColor, 1.0), strength * mask);
    return float4(color, 1.0);
}
ENDCG
#END
