#DEFPARAMS
MainTex = { "main Color", TEXTURE2D, "white" },
NormalTexture = {"Normal Map", TEXTURE2D, "white"},
BkgTintTex = {"BkgTintTex Map", TEXTURE2D, "white"},
BkgMaterialTex = {"BkgMaterialTex Map", TEXTURE2D, "white"},
BkgNormalTex = {"BkgNormalTex Map", TEXTURE2D, "white"},
PatternAlbedoTex = {"PatternAlbedoTex Map", TEXTURE2D, "white"},
PatternNormalTex = {"PatternNormalTex Map", TEXTURE2D, "white"},

FBkgNormalIntensity = { "FBkgNormalIntensity", FLOAT, "0.5" },
Metallic = { "Metallic", FLOAT, "0.5" },
Smoothness = { "Smoothness", FLOAT, "0.5" },
EnvSpecIntensity = { "EnvSpecIntensity", FLOAT, "0.5" },
UseBkgNormal = { "UseBkgNormal", FLOAT, "1.0" },
UsePatternAlbedo = { "UsePatternAlbedo", FLOAT, "1.0" },
UsePatternNormal = { "UsePatternNormal", FLOAT, "1.0" },

BkgScaleOffset = { "BkgScaleOffset", VEC4, "1.0,1.0,0.0,0.0" },
Bkguv02 = { "Bkguv02", FLOAT, "1.0" },
Patternuv32 = { "Patternuv32", FLOAT, "1.0" },

SpecularColor = {"Specular Color", COLOR, "1.0,1.0,1.0,1.0"},
#END

#DEFTAG
ShaderName = "StandardOpaque"
RenderQueue = "Opaque"
#END

#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdbase_noskin
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float3 binoraml : BINORMAL;
	float3 tangent : TANGENT;
	float2 uv0 : TEXCOORD0;
    float2 uv1 : TEXCOORD1;
    float2 uv2 : TEXCOORD2;
    float2 uv3 : TEXCOORD3;
};

struct v2f
{
	float4 uv0 : TEXCOORD0;
	float4 worldnormal : TEXCOORD1;
	float4 worldtangent : TEXCOORD2;
	float4 worldbinormal : TEXCOORD3;
	float4 vertex : SV_POSITION;
	SHADOW_COORDS(4)
    float4 uv1 : TEXCOORD5;
    float4 uv2 : TEXCOORD6;
    
};

sampler2D MainTex;
sampler2D NormalTexture;
sampler2D BkgTintTex;
sampler2D BkgMaterialTex;
sampler2D BkgNormalTex;
sampler2D PatternAlbedoTex;
sampler2D PatternNormalTex;

float FBkgNormalIntensity;
float Metallic;
float Smoothness;
float EnvSpecIntensity;
float UseBkgNormal;
float UsePatternAlbedo;
float UsePatternNormal;
float4 SpecularColor;
float4 BkgScaleOffset;
float Bkguv02;
float Patternuv32;

v2f vert(appdata v)
{
   
  v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv0.xy = v.uv0.xy;
    o.uv0.zw = v.uv1.xy;

	float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
	o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;
	o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;

	o.worldnormal.w = worldpos.x;
	o.worldtangent.w = worldpos.y;
	o.worldbinormal.w = worldpos.z;
  TRANSFER_SHADOW(o, v.vertex);

    if (Patternuv32 > 0.0)
    {
      o.uv1.zw = v.uv2.xy;
    }
    else
    {
      o.uv1.zw = v.uv3.xy;
    }
    
    if (Bkguv02 > 0.0)
    {
      o.uv2.xy = v.uv2.xy * BkgScaleOffset.xy + BkgScaleOffset.zw;
    }
    else
    {
       o.uv2.xy = v.uv0.xy * BkgScaleOffset.xy + BkgScaleOffset.zw;
    }

	return o;
}

float4 frag(v2f i, float FacingSign : VFACE) : SV_Target
{
    float4 in_Coordinate0 = i.uv0;
    float4 in_Coordinate1 = i.uv1;
    float4 in_Coordinate2 = i.uv2;
    float4 in_NormalWS = i.worldnormal;
    float4 in_TangentWS = i.worldtangent;
    float4 in_BinormalWS = i.worldbinormal;

    float ShadowMask = SHADOW_ATTEN(i);

    float3 worldPos = float3(in_NormalWS.w, in_TangentWS.w, in_BinormalWS.w);
    float3 viewDir_S = CAMERA_WORLDPOSITION - worldPos.xyz;
    float3 viewDir = normalize(viewDir_S);

    float3 mainNormal = tex2D(NormalTexture, in_Coordinate0.xy).xyz;
    float3 groundNormal = mainNormal.xyz * 2.0 - 1.0;

    float3 bkgNormal = float3(0.0, 0.0, 1.0);
    if (UseBkgNormal > 0.0)
    {
      float tileCount = min(abs(BkgScaleOffset.x), abs(BkgScaleOffset.y));
      tileCount -= 20.0;
      tileCount = max(0.0, tileCount);
      float rimReduce = tileCount > 0.0 ? 1.0 : 0.0;
      float len = sqrt(dot(viewDir_S, viewDir_S));
      len = 0.9333333 - 0.33333331 * len;
      len = clamp(len, 0.0, 1.0);
      float BkgNormalIntensity = lerp(1.0, len, rimReduce);

      float2 texNormal = tex2D(BkgNormalTex, in_Coordinate2.xy).xy;
      bkgNormal = float3(texNormal.xy, 0.0);
      float dotV;
      bkgNormal.xy = (bkgNormal.xy * 2.0 - 1.0) * FBkgNormalIntensity * BkgNormalIntensity;
      dotV = dot(bkgNormal.xy, bkgNormal.xy);
      bkgNormal.z = sqrt(1.0 - min(dotV, 1.0));
    }

    if (UsePatternNormal > 0.0)
    {
      float weight = mainNormal.z;
      float2 patternNormal = tex2D(PatternNormalTex, in_Coordinate2.xy).xy;
      float3 patternNormal1 = float3(patternNormal.xy * 2.0 - 1.0, 0.0);
      patternNormal1.z = sqrt(1.0 - dot(patternNormal1.xy, patternNormal1.xy));

      weight *= tex2D(PatternAlbedoTex, in_Coordinate1.zw).w;
      float3 outNormal = lerp(bkgNormal, patternNormal1, weight);
      bkgNormal = outNormal;
    }

    // blend normal
    float3 n1 = groundNormal;
    float3 n2 = bkgNormal;
    n1 += float3(0.0, 0.0, 1.0);
    n2 *= float3(-1.0, -1.0, 1.0);
    float3 blendedNormal = n1 * dot(n1, n2) / n1.z - n2;
    float backLightingWeight = 1.0;
    
    if(!FacingSign)
    {
         blendedNormal = -blendedNormal;
         backLightingWeight = 0.0;
    }

    // normal in world space
    float3 worldNormal = blendedNormal.x * in_TangentWS.xyz + blendedNormal.y * in_BinormalWS.xyz
					+ blendedNormal.z * in_NormalWS.xyz;
    worldNormal = normalize(worldNormal);

    float3 light1Dir = -(LIGHT_GIVEN_DIRECTION);
     float3 h1 = normalize(viewDir + light1Dir);
	  float nv = max(dot(worldNormal, viewDir), 0.0);
	  float nh1 = max(dot(worldNormal, h1), 0.0);

       // main color
    float3 mainColor = tex2D(MainTex, in_Coordinate0.xy).xyz;

    // bkg tint
    float3 bgTintColor = tex2D(BkgTintTex, in_Coordinate0.zw).xyz;
    
    if (UsePatternAlbedo > 0.0)
    {
      float4 patternAlbedo = tex2D(PatternAlbedoTex, in_Coordinate1.zw).xyzw;
      float bkgTintWeight = mainNormal.z * patternAlbedo.w;
      bgTintColor = lerp(bgTintColor.xyz, patternAlbedo.xyz, bkgTintWeight);
    }

    // blend main and bkg
    mainColor *= bgTintColor;
	  mainColor *= mainColor;

      // diffuse
    float3 shadowColor = float3(ShadowMask, ShadowMask, ShadowMask);
    float3 diffuse = float3(0.0, 0.0, 0.0);
    float nl1 = dot(worldNormal, light1Dir);
	  float nl1Warp = max((nl1 + 1.0) * 0.5, 0.0);
	  nl1 = max(nl1, 0.0);
	  diffuse += nl1 * LIGHT_COLOR * shadowColor;

      float3 outDiffuse = (diffuse + AMBIENT_COLOR.xyz) * mainColor;

      float2 metalSmooth = tex2D(BkgMaterialTex, in_Coordinate0.zw).xy * float2(Metallic, Smoothness);
    float2 invSmoothMetal = float2(1.0, 1.0) - metalSmooth.yx;
	  float roughness = invSmoothMetal.x;
	  float metal = metalSmooth.x;

    // fresnel
    float fresnel = 1.0 - nv;
	  fresnel *= fresnel;
	  fresnel *= fresnel;

       float3 iblColor = float3(0.0, 0.0, 0.0);

    // specular color
    float3 DielectricSpec = float3(0.2209163, 0.2209163, 0.2209163);
	  float3 specularCol = lerp(DielectricSpec, mainColor, metal);
    
    // D     
    float modifyRoughness = max(roughness * roughness, 0.1);
    float NdotH = nh1;
    float a2 = modifyRoughness * modifyRoughness;
    float d = (NdotH * a2 - NdotH) * NdotH + 1.0f; // 2 mad
	  d = 0.31830988618f * a2 / (d * d + 1e-7f);
	  d = min(d, 100.0);

    // F
    float f0 = lerp(DielectricSpec.x, 1.0, metal);
	  float f = f0 + (1.0 - f0) * fresnel;

    float3 outSpecular = (d * f * nl1Warp * SpecularColor.xyz * LIGHT_COLOR + iblColor) * specularCol;

    float4 finalCol;
    finalCol.xyz = float3(outDiffuse.xyz * invSmoothMetal.y + outSpecular.xyz);
    finalCol.w = 1.0;
 
    return finalCol;
}

ENDCG

#END

#DEFPASS ForwardAdd
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, ONE, ONE, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDADD }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdadd_noskin
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float3 binoraml : BINORMAL;
	float3 tangent : TANGENT;
	float2 uv0 : TEXCOORD0;
    float2 uv1 : TEXCOORD1;
    float2 uv2 : TEXCOORD2;
    float2 uv3 : TEXCOORD3;
};

struct v2f
{
	float4 uv0 : TEXCOORD0;
	float4 worldnormal : TEXCOORD1;
	float4 worldtangent : TEXCOORD2;
	float4 worldbinormal : TEXCOORD3;
	float4 vertex : SV_POSITION;
	SHADOW_COORDS(4)
    float4 uv1 : TEXCOORD5;
    float4 uv2 : TEXCOORD6;
};

sampler2D MainTex;
sampler2D NormalTexture;
sampler2D BkgTintTex;
sampler2D BkgMaterialTex;
sampler2D BkgNormalTex;
sampler2D PatternAlbedoTex;
sampler2D PatternNormalTex;

float FBkgNormalIntensity;
float Metallic;
float Smoothness;
float EnvSpecIntensity;
float UseBkgNormal;
float UsePatternAlbedo;
float UsePatternNormal;
float4 SpecularColor;
float4 BkgScaleOffset;
float Bkguv02;
float Patternuv32;

v2f vert(appdata v)
{
   
  v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv0.xy = v.uv0.xy;
    o.uv0.zw = v.uv1.xy;

	float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
	o.worldtangent.xyz = ObjectToWorldDir(v.tangent).xyz;
	o.worldbinormal.xyz = ObjectToWorldDir(v.binoraml).xyz;

	o.worldnormal.w = worldpos.x;
	o.worldtangent.w = worldpos.y;
	o.worldbinormal.w = worldpos.z;
  TRANSFER_SHADOW(o, v.vertex);

    if (Patternuv32 > 0.0)
    {
      o.uv1.zw = v.uv2.xy;
    }
    else
    {
      o.uv1.zw = v.uv3.xy;
    }
    
    if (Bkguv02 > 0.0)
    {
      o.uv2.xy = v.uv2.xy * BkgScaleOffset.xy + BkgScaleOffset.zw;
    }
    else
    {
       o.uv2.xy = v.uv0.xy * BkgScaleOffset.xy + BkgScaleOffset.zw;
    }

	return o;
}

float4 frag(v2f i, float FacingSign : VFACE) : SV_Target
{
    float4 in_Coordinate0 = i.uv0;
    float4 in_Coordinate1 = i.uv1;
    float4 in_Coordinate2 = i.uv2;
    float4 in_NormalWS = i.worldnormal;
    float4 in_TangentWS = i.worldtangent;
    float4 in_BinormalWS = i.worldbinormal;

    float ShadowMask = SHADOW_ATTEN(i);

    float3 worldPos = float3(in_NormalWS.w, in_TangentWS.w, in_BinormalWS.w);
    float3 viewDir_S = CAMERA_WORLDPOSITION - worldPos.xyz;
    float3 viewDir = normalize(viewDir_S);

    float3 mainNormal = tex2D(NormalTexture, in_Coordinate0.xy).xyz;
    float3 groundNormal = mainNormal.xyz * 2.0 - 1.0;

    float3 bkgNormal = float3(0.0, 0.0, 1.0);
    if (UseBkgNormal > 0.0)
    {
      float tileCount = min(abs(BkgScaleOffset.x), abs(BkgScaleOffset.y));
      tileCount -= 20.0;
      tileCount = max(0.0, tileCount);
      float rimReduce = tileCount > 0.0 ? 1.0 : 0.0;
      float len = sqrt(dot(viewDir_S, viewDir_S));
      len = 0.9333333 - 0.33333331 * len;
      len = clamp(len, 0.0, 1.0);
      float BkgNormalIntensity = lerp(1.0, len, rimReduce);

      float2 texNormal = tex2D(BkgNormalTex, in_Coordinate2.xy).xy;
      bkgNormal = float3(texNormal.xy, 0.0);
      float dotV;
      bkgNormal.xy = (bkgNormal.xy * 2.0 - 1.0) * FBkgNormalIntensity * BkgNormalIntensity;
      dotV = dot(bkgNormal.xy, bkgNormal.xy);
      bkgNormal.z = sqrt(1.0 - min(dotV, 1.0));
    }

    if (UsePatternNormal > 0.0)
    {
      float weight = mainNormal.z;
      float2 patternNormal = tex2D(PatternNormalTex, in_Coordinate2.xy).xy;
      float3 patternNormal1 = float3(patternNormal.xy * 2.0 - 1.0, 0.0);
      patternNormal1.z = sqrt(1.0 - dot(patternNormal1.xy, patternNormal1.xy));

      weight *= tex2D(PatternAlbedoTex, in_Coordinate1.zw).w;
      float3 outNormal = lerp(bkgNormal, patternNormal1, weight);
      bkgNormal = outNormal;
    }

    // blend normal
    float3 n1 = groundNormal;
    float3 n2 = bkgNormal;
    n1 += float3(0.0, 0.0, 1.0);
    n2 *= float3(-1.0, -1.0, 1.0);
    float3 blendedNormal = n1 * dot(n1, n2) / n1.z - n2;
    float backLightingWeight = 1.0;

    if(!FacingSign)
    {
         blendedNormal = -blendedNormal;
         backLightingWeight = 0.0;
    }


    // normal in world space
    float3 worldNormal = blendedNormal.x * in_TangentWS.xyz + blendedNormal.y * in_BinormalWS.xyz
					+ blendedNormal.z * in_NormalWS.xyz;
    worldNormal = normalize(worldNormal);

    float3 light1Dir = -(LIGHT_GIVEN_DIRECTION);
     float3 h1 = normalize(viewDir + light1Dir);
	  float nv = max(dot(worldNormal, viewDir), 0.0);
	  float nh1 = max(dot(worldNormal, h1), 0.0);

       // main color
    float3 mainColor = tex2D(MainTex, in_Coordinate0.xy).xyz;

    // bkg tint
    float3 bgTintColor = tex2D(BkgTintTex, in_Coordinate0.zw).xyz;
    
    if (UsePatternAlbedo > 0.0)
    {
      float4 patternAlbedo = tex2D(PatternAlbedoTex, in_Coordinate1.zw).xyzw;
      float bkgTintWeight = mainNormal.z * patternAlbedo.w;
      bgTintColor = lerp(bgTintColor.xyz, patternAlbedo.xyz, bkgTintWeight);
    }

    // blend main and bkg
    mainColor *= bgTintColor;
	  mainColor *= mainColor;

      // diffuse
    float3 shadowColor = float3(ShadowMask, ShadowMask, ShadowMask);
    float3 diffuse = float3(0.0, 0.0, 0.0);
    float nl1 = dot(worldNormal, light1Dir);
	  float nl1Warp = max((nl1 + 1.0) * 0.5, 0.0);
	  nl1 = max(nl1, 0.0);

         float nl2 = (dot(worldNormal, light1Dir) + 0.5) * 0.7;
    nl2 = max(nl2, 0.0);
	  nl2 = nl2 * nl2;
	  nl2 = nl2 * nl2;
	  nl2 = nl2 * nl2;
	  diffuse += nl2 * LIGHT_COLOR * backLightingWeight;
	  
      float3 outDiffuse = (diffuse) * mainColor;

      float2 metalSmooth = tex2D(BkgMaterialTex, in_Coordinate0.zw).xy * float2(Metallic, Smoothness);
    float2 invSmoothMetal = float2(1.0, 1.0) - metalSmooth.yx;
	  float roughness = invSmoothMetal.x;
	  float metal = metalSmooth.x;

    // fresnel
    float fresnel = 1.0 - nv;
	  fresnel *= fresnel;
	  fresnel *= fresnel;

       float3 iblColor = float3(0.0, 0.0, 0.0);

    // specular color
    float3 DielectricSpec = float3(0.2209163, 0.2209163, 0.2209163);
	  float3 specularCol = lerp(DielectricSpec, mainColor, metal);
    
    // D
    float modifyRoughness = max(roughness * roughness, 0.1);
    float NdotH = nh1;
    float a2 = modifyRoughness * modifyRoughness;
    float d = (NdotH * a2 - NdotH) * NdotH + 1.0f; // 2 mad
	  d = 0.31830988618f * a2 / (d * d + 1e-7f);
	  d = min(d, 100.0);

    // F
    float f0 = lerp(DielectricSpec.x, 1.0, metal);
	  float f = f0 + (1.0 - f0) * fresnel;

    float3 outSpecular = (d * f * nl1Warp * SpecularColor.xyz * LIGHT_COLOR + iblColor) * specularCol;

    float4 finalCol;
    finalCol.xyz = float3(outDiffuse.xyz * invSmoothMetal.y);
    finalCol.w = 1.0;

    return finalCol;
} 

ENDCG

#END

#DEFPASS Depth
	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	CGPROGRAM
	#pragma vertex vert
	#pragma fragment frag
	#include "lightpbr.inc"

	struct appdata
	{
		float4 vertex : POSITION;
		float3 normal : NORMAL;
    ANI_ATTRIBUTE
	};

	struct v2f
	{
		float4 vertex : SV_POSITION;
	};

	v2f vert(appdata v)
	{
    COMPUTE_BONE_MATERIX(v);
		float4 clipPos = ObjectToClipPos(v.vertex);
		clipPos = ApplyShadowBias(clipPos);

		v2f o;
		o.vertex = UniformNDC(clipPos);
		return o;
	}

	float4 frag(v2f i) : SV_Target
	{
		return float4(0.0, 0.0, 0.0, 1.0);
	}
	ENDCG
#END