#DEFPARAMS
diffuseMap = { "diffuseMap", TEXTURE2D, "white" },
specularMap = { "specularMap", TEXTURE2D, "white" },
heightMap = { "heightMap", TEXTURE2D, "white" },

movespeed1 = { "movespeed1", FLOAT, "0.5" },
movespeed2 = { "movespeed2", FLOAT, "0.5" },
movespeed3 = { "movespeed3", FLOAT, "0.5" },
eyeheight = { "eyeheight", FLOAT, "0.5" },

specoffset1 = { "specoffset1", VEC3, "0.0,0.0,0.0" },
specoffset2 = { "specoffset2", VEC3, "0.0,0.0,0.0" },
specoffset3 = { "specoffset3", VEC3, "0.0,0.0,0.0" },
initoffset = { "initoffset", VEC3, "0.0,0.0,0.0" },
intensity = { "intensity", VEC3, "0.0,0.0,0.0" },


in_LightDirection = { "LIGHT1DIR", VEC3, "0.0,0.0,1.0" },
LIGHT1COLOR = { "LIGHT1COLOR", COLOR, "1.0,1.0,1.0,1.0" },
Light1Intensity = { "LIGHT1INTENSITY", FLOAT, "1.0" },
 
#END

#DEFTAG
ShaderName = "DollEye"
RenderQueue = "Opaque"
#END

#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }
 
CGPROGRAM 
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdbase_noskin
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float2 uv0 : TEXCOORD0;
    float2 uv1 : TEXCOORD1; 
};

struct v2f
{
	float2 uv0 : TEXCOORD0;
    float2 uv1 : TEXCOORD1;
	float4 worldnormal : TEXCOORD2;
    float3 worldPos : TEXCOORD3;
	float4 vertex : SV_POSITION;
	SHADOW_COORDS(4)
};

sampler2D diffuseMap;
sampler2D specularMap;
sampler2D heightMap;

float movespeed1;
float movespeed2;
float movespeed3;
float eyeheight;

float3 specoffset1;
float3 specoffset2;
float3 specoffset3;
float3 initoffset;
float3 intensity;

float3 in_LightDirection;
float4 LIGHT1COLOR; 
float Light1Intensity;

v2f vert(appdata v)
{
	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv0 = v.uv0.xy;
    o.uv1 = v.uv1;
	float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
    o.worldPos = worldpos;
	
	TRANSFER_SHADOW(o, v.vertex);
	return o;
}

float4 frag(v2f i) : SV_Target
{
    float2 in_Coordinate0 = i.uv0;
    float2 in_Coordinate1 = i.uv1;

    float3 eyeright = ObjectToWorldNormal(float3(1.0, 0.0, 0.0));
    float3 eyeup = ObjectToWorldNormal(float3(0.0, 1.0, 0.0));

    float3 viewDir_S = CAMERA_WORLDPOSITION - i.worldPos.xyz;
    float3 vView = normalize(viewDir_S);
    float3 vLight = (in_LightDirection);

    float vr = dot(vView, eyeright);
    float vu = dot(vView, eyeup);

    float2 coord0 = float2(-vr*vr*vr, -vr);
    coord0 *= movespeed1;
    coord0 *= specoffset1.xy;
    coord0 = coord0 + initoffset.xy + float2(in_Coordinate1.x, 1.0 - in_Coordinate1.y);
    coord0.y = 1.0 - coord0.y;

    float specular0 = tex2D(specularMap, coord0).x;

    float2 coord1 = float2(vr, -vu);
    coord1 *= movespeed2;
    coord1 *= specoffset2.xy;
    coord1 = coord1 + initoffset.xy + float2(in_Coordinate1.x, 1.0 - in_Coordinate1.y);
    coord1.y = 1.0 - coord1.y;
    float specular1 = tex2D(specularMap, coord1).y;

    float2 coord2 = abs(float2(vr, vr));
    coord2 *= movespeed3;
    coord2 *= specoffset3.xy;
    coord2 = coord2 + initoffset.xy + float2(in_Coordinate1.x, 1.0 - in_Coordinate1.y);
    coord2.y = 1.0 - coord2.y;

     float specular2 = tex2D(specularMap, coord2).z;

    float totalSpecular = dot(float3(specular0,specular1,specular2), intensity);

    float2 heightOffset = float2(vr, -vu) * eyeheight * 0.5;
    float height0 = tex2D(heightMap, in_Coordinate0).x;

    float2 hcoord1 = float2(height0) * heightOffset + float2(in_Coordinate0.x, 1.0 - in_Coordinate0.y);
    hcoord1.y = 1.0 - hcoord1.y;

    float height1 = tex2D(heightMap, hcoord1).x;

    float2 hcoord2 = float2(height1,height1) * heightOffset + float2(in_Coordinate0.x, 1.0 - in_Coordinate0.y);
    hcoord2.y = 1.0 - hcoord2.y;
    float height2 = tex2D(heightMap, hcoord2).x;

    float2 hcoord3 = float2(height2, height2) * heightOffset + float2(in_Coordinate0.x, 1.0 - in_Coordinate0.y);
    hcoord3.y = 1.0 - hcoord3.y;
    float3 mainColor = tex2D(diffuseMap, hcoord3).xyz;
    mainColor *= mainColor;

    float ShadowMask = SHADOW_ATTEN(i); 
    float3 light = LIGHT1COLOR.xyz * Light1Intensity * ShadowMask + AMBIENT_COLOR;
    float3 finalColor = mainColor + float3(totalSpecular, totalSpecular, totalSpecular);
    finalColor *= light;

    float4 out_Color = float4(finalColor, 1.0);
    return out_Color;
}
ENDCG
#END

#DEFPASS Depth
	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	CGPROGRAM
	#pragma vertex vert
	#pragma fragment frag
	#include "lightpbr.inc"

	struct appdata
	{
		float4 vertex : POSITION;
		float3 normal : NORMAL;
	};
  
	struct v2f
	{
		float4 vertex : SV_POSITION;
	};
 
	v2f vert(appdata v) 
	{
		float4 clipPos = ObjectToClipPos(v.vertex);
		clipPos = ApplyShadowBias(clipPos);

		v2f o;
		o.vertex = UniformNDC(clipPos);
		return o;
	}

	float4 frag(v2f i) : SV_Target
	{
		return float4(0.0, 0.0, 0.0, 1.0);
	}
	ENDCG
#END