

#DEFPARAMS
_MainTex = { "main Color", TEXTURE2D, "white" },
[Enum(BlendFunc)]
_BlendSrc = {"blendsrc", FLOAT, "4.0"},
[Enum(BlendFunc)]
_BlendDst = {"blenddst", FLOAT, "5.0"},
#END


#DEFTAG
ShaderName = "sticker_quad"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc", "%_BlendDst", ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_skin
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
	ANI_ATTRIBUTE
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D _MainTex;

v2f vert(appdata v)
{
    COMPUTE_BONE_MATERIX(v);
	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
	// sample the texture
	float4 mainColor = tex2D(_MainTex, i.uv);
	return mainColor;
}
ENDCG
#END
