

#DEFPARAMS
_BGTex = { "BG Texture", TEXTURE2D, "white" },
_MaskTex = { "Mask Texture", TEXTURE2D, "white" },
_CutOff = { "CutOff", FLOAT, "0.2" },
#END

#DEFTAG
ShaderName = "avatardepthmask"
RenderQueue = "Overlay"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM   
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
};

struct v2f
{ 
	float4 vertex : SV_POSITION;
    float2 uv : TEXCOORD0;
};

sampler2D _BGTex;
sampler2D _MaskTex;
float _CutOff;

v2f vert(appdata v)
{  
	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
    o.uv = o.vertex.xy/o.vertex.w;
    o.uv = (o.uv+float2(1.0,1.0))/2.0;
	return o;
}
   
float4 frag(v2f i) : SV_Target   
{
    float4 maskcolor =  tex2D(_MaskTex, i.uv);
    float4 bgcolor =  tex2D(_BGTex, i.uv);
  
    if (maskcolor.a<_CutOff) discard; 
    bgcolor.a = maskcolor.a;

    return bgcolor;
}
ENDCG
#END
