

#DEFPARAMS
_MainTex = { "main Color", TEXTURE2D, "white" },
[Enum(ON,1,OFF,0)]
_BlendState = {"belnd state", FLOAT, "0.0"},
[Enum(BlendFunc)]
_BlendSrc = {"blendsrc", FLOAT, "1.0"},
[Enum(DepthMode)]
_DepthState = {"depth state", FLOAT, "1.0"},
[Enum(DepthFunc)]
_DepthFc = {"depth fc", FLOAT, "1.0"},
[Keywords(CRED,CBLUE,CDEF)]
_keydef = {"keydef", FLOAT, "2.0"},
#END

#DEFTAG
ShaderName = "statetest"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { "%_BlendState", "%_BlendSrc", ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, "%_DepthState", "%_DepthFc" }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile CRED CBLUE CDEF
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D _MainTex;

v2f vert(appdata v)
{
	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
#ifdef CRED
	return float4(1.0,0.0,0.0,1.0);
#endif

#ifdef CBLUE
	return float4(0.0,0.0,1.0,1.0);
#endif
	// sample the texture
	float4 mainColor = tex2D(_MainTex, i.uv);
	return mainColor;
}
ENDCG
#END
