local SequenceAnimation = require "apolloutility.sequenceanimation"
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
local Faceinfo = require "videodecet.faceinfo";
local Actioninfo = require "videodecet.actioninfo";
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local likeapp = require "likeapp"


local g_w = 1080;
local g_h = 1920;
local testvidesize = {1080, 1920}

local videodecet = {}
setmetatable(videodecet, basedetect);

function videodecet:Initialize(imagedoc, imagefile, pointfile)
  
  --新帧回调
  self.newframecallback = {}
  setmetatable(self.newframecallback, {__mode = "v"})

  apolloengine.ShaderEntity.POINT_COLOR = 
    apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "POINT_COLOR");
    
  self.animation = SequenceAnimation(defiend.blit_material_path);
  --self.animation:SetShow(false);
  renderqueue:Before(self.animation)
  
  self.animation:Play(imagedoc, imagefile, nil, 30, true, 1);

  --创建解析服务
  self.paserservice = venuscore.IServicesSystem:Create("videodecet.paserservice_body");

  self.bodypoints = {}
  local keypointcount = self.paserservice:GetKeyPointCount();
  
  local pr = apollonode.PointNode();
  pr:CreateResource(
    keypointcount,
    mathfunction.vector4(0,1,0,1),
    "comm:documents/material/pointrender.material");
  renderqueue:Before(pr);
  self.pointrender = pr;  
  
  --解析关键点
  self.frameindex = 0;
  self.bodypoints = {}
  self.insertfunction = function (bodydata)
    table.insert(self.bodypoints, bodydata);
    return true;
  end
  local agent, index = g_callbackhandle:RegisterCallback(self.insertfunction);
  local fullpath = venuscore.IFileSystem:PathAssembly(imagedoc..pointfile);
  self.paserservice:PaserFile(agent, index, testvidesize, fullpath);  
end

function videodecet:ShowKeypoint(isshow)
  
end

function videodecet:AddNewframeCallback(func)
  table.insert(self.newframecallback, func);
end

local function _toRelativeCoordinates(pixel_x, pixel_y)
  return pixel_x / g_w * 2 - 1, 1 - pixel_y / g_h * 2;
end

function videodecet:Update(def)
  local _, frame = self.animation:Update(def);
  if self.frameindex ~= frame then
    self.frameindex = frame;
    local body = self.bodypoints[frame];
    if body then
      local pr = self.pointrender;
      local bodyvectors = {}
      for i=1, 28, 2 do
        table.insert(bodyvectors, { _toRelativeCoordinates(body[i], body[i+1]) });
      end      
      pr:Update(bodyvectors);
    end
    for _, func in ipairs(self.newframecallback) do
      func();
    end
    return true;
  end
  return false;
end

function videodecet:SetTexture(tex)
end

--得到当前的人脸信息
function videodecet:GetFaces()
  return nil;
end

function videodecet:UpdateKeypoints(idx,keypoint)
end

function videodecet:GetActions()
  return nil;
end

function videodecet:ActiveActions(actions)
  likeapp.AI:ActiveActions(actions)
end

function videodecet:GetBodyPoints()
  return self.bodypoints[self.frameindex];
end

function videodecet:GetVideoSize()
  return testvidesize;
end

--得到当前的视屏纹理
function videodecet:GetVideoTexture()
  return self.animation:GetCurrentTexture();
end

return videodecet;