local SequenceAnimation = require "apolloutility.sequenceanimation"
local ImageService = require "apolloutility.texturereader"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local stringsplit = require "stringsplit"
local venuscore = require "venuscore"
local Object = require "classic"


local faceinfo = Object:extend();

local g_w = 0;
local g_h = 0;

local function _toRelativeCoordinates(pixel_x, pixel_y)
  return pixel_x / g_w * 2 - 1, 1 - pixel_y / g_h * 2;
end

function faceinfo:new(vidoesize)
  --self.size = vidoesize;
  g_w = vidoesize[1];
  g_h = vidoesize[2];
  self.Keypoint = {}--关键点
  self.PixelKeypoint = {} --原始像素关键点
  self.Extended = {}--额外关键点
  self.blocking = {}
  self.forehead = {}--额头点
  self.ExtraKeypoint = {}--新增关键点
  self.DetailKeypoint = {} --包含眉毛、眼睛、嘴巴细致关键点
end


function faceinfo:PushKeypoint(pixel_x,pixel_y)
  table.insert(self.PixelKeypoint,{pixel_x,pixel_y});
  local x,y = _toRelativeCoordinates(pixel_x,pixel_y);
  table.insert(self.Keypoint,{x,y});
end

function faceinfo:PushExtended(pixel_x,pixel_y)
  local x,y = _toRelativeCoordinates(pixel_x,pixel_y);
  table.insert(self.Extended, {x,y});
end

function faceinfo:PushForeheadLandmark(pixel_x,pixel_y)
  local x,y = _toRelativeCoordinates(pixel_x,pixel_y);
  table.insert(self.forehead,{x,y});
end

function faceinfo:PushRect(pixel_left,pixel_top,pixel_right,pixel_bottom)
  local l,t = _toRelativeCoordinates(pixel_left,pixel_top);
  local r,b = _toRelativeCoordinates(pixel_right,pixel_bottom);
  self.rect = {l,t,r,b};
end

function faceinfo:PushRotation(p, r, y)
  self.picthrollyaw = {p,r,y};
end

function faceinfo:PushBlocking(isblocak)
  table.insert(self.blocking, isblocak);
end

function faceinfo:PushExtraKeypoint(pixel_x,pixel_y)
  local x,y = _toRelativeCoordinates(pixel_x,pixel_y);
  table.insert(self.ExtraKeypoint,{x,y});
end


function faceinfo:GetRotation()
  return self.picthrollyaw;
end

function faceinfo:GetRect()
  return self.rect;
end

--由于lua数组从1开始而商汤是从0开始所以+1
function faceinfo:GetKeypoint(id)
  return self.Keypoint[id+1];
end

function faceinfo:GetKeypointArray()
  return self.Keypoint;
end

function faceinfo:GetPixelKeypointArray()
  return self.PixelKeypoint;
end

function faceinfo:GetForeheadLandmark()
  return self.forehead;
end

function faceinfo:GetExtraKeypoint(id)
  return self.ExtraKeypoint[id+1];
end

function faceinfo:GetExtraKeypointArray()
  return self.ExtraKeypoint;
end

function faceinfo:GetDetailpointArray()
  for i =1,33 do
    self.DetailKeypoint[i] = self.Keypoint[i];
  end
  for i = 34,42 do
    self.DetailKeypoint[i] = self.Keypoint[i+10];
  end
  for i = 43,48 do
    self.DetailKeypoint[i] = self.Keypoint[i+36];
  end
  for i = 49,182 do
    self.DetailKeypoint[i] = self.ExtraKeypoint[i-48];
  end
  return self.DetailKeypoint;
end

function faceinfo:UpdateKeypoints(keypoint)
  for i = 1,#keypoint,1 do
    self.Keypoint[i] = keypoint[i];
  end
end

function faceinfo:UpdateExtraKeypoints(keypoint)
  for i = 1,#keypoint,1 do
    self.ExtraKeypoint[i] = keypoint[i];
  end
end

function faceinfo:GetExtended(id)
  return self.Extended[id+1];
end

function faceinfo:GetBlocking(id)
  return self.blocking[id+1];
end


function faceinfo:GetExtendedArray()
  return self.Extended;
end

function faceinfo:GetBlockingArray()
  return self.blocking;
end

function faceinfo:toAbsoluteCoordinates(rel)
    return ( rel[1] + 1 ) * g_w / 2 , ( 1 - rel[2] ) * g_h /2 ;
end

return faceinfo;