local blendshape = require "shapemodel"
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local venusjson = require "venusjson"
local mathfunction = require "mathfunction"
local venusblendshape = {}

function venusblendshape:Initialize(MeshesJSON)
	--load of face--
	local modelconfig = venusjson.LaodJsonFile(MeshesJSON);
	local render  = modelconfig.face.render;
	local pos     = modelconfig.face.pos;
	local texture = modelconfig.face.texture;
	local mesh    = modelconfig.face.mesh;
	self.model_face = apollonode.MeshNode();
	self.model_face:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,texture);
	self.model_face:SetShow(true);
    self.model_face.render:SetKeepSource(true);
    self.model_face:CreateResource(mesh,render,Nil,Nil,Nil,Nil,apolloengine.VertexBufferEntity.MU_DYNAMIC);
	self.bs = blendshape.BS();--调用构造函数
    local vertexstream = self.model_face.render:GetVertexStream();
    self.bs:load_blendshape(vertexstream);
	
	local count = 1;
	self.model = {};
	self.bsmodel={};
	for meshesKey, meshesValue in pairs(modelconfig.blendshape.models) do
		meshpath = modelconfig.blendshape.path .. meshesValue .. ".mesh";
		self.model[count] = apollonode.MeshNode();
		self.model[count]:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,texture);
		self.model[count].render:SetKeepSource(true);
		self.model[count]:CreateResource(meshpath,render,Nil,Nil,Nil,Nil,apolloengine.VertexBufferEntity.MU_DYNAMIC);
		self.model[count]:SetShow(false);
		--self.bs:load_blendshape(vertexstream);
		vertexstream = self.model[count].render:GetVertexStream();
		self.bs:load_blendshape(vertexstream);
		self.bsmodel[meshesValue] = count;
		count = count + 1;
	end
	self.bs:build_blendshape();
	--left eye
	self.model[count] = apollonode.MeshNode();
	self.model[count]:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,modelconfig.eyes.left.texture);
    self.model[count].render:SetKeepSource(true);
    self.model[count]:SetShow(true);
    self.model[count]:CreateResource(modelconfig.eyes.left.mesh,render,Nil,Nil,Nil,Nil,apolloengine.VertexBufferEntity.MU_DYNAMIC);
	self.model[count]:SetLocalPosition(mathfunction.vector3(modelconfig.eyes.left.pos[1],modelconfig.eyes.left.pos[2],modelconfig.eyes.left.pos[3]));
    self.model_face:AttachNode(self.model[count]);
	self.bsmodel["left_eye"] = count;
	--right eye
	count = count + 1;
	self.model[count] = apollonode.MeshNode();
	self.model[count]:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,modelconfig.eyes.right.texture);
    self.model[count].render:SetKeepSource(true);
    self.model[count]:SetShow(true);
    self.model[count]:CreateResource(modelconfig.eyes.right.mesh,render,Nil,Nil,Nil,Nil,apolloengine.VertexBufferEntity.MU_DYNAMIC);
	self.model[count]:SetLocalPosition(mathfunction.vector3(modelconfig.eyes.right.pos[1],modelconfig.eyes.right.pos[2],modelconfig.eyes.right.pos[3]));
    self.model_face:AttachNode(self.model[count]);
	self.bsmodel["right_eye"] = count;
	--lower_teeth
	count = count + 1;
	self.model[count] = apollonode.MeshNode();
	self.model[count]:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,modelconfig.lower_teeth.texture);
    self.model[count].render:SetKeepSource(true);
    self.model[count]:SetShow(true);
    self.model[count]:CreateResource(modelconfig.lower_teeth.mesh,render,Nil,Nil,Nil,Nil,apolloengine.VertexBufferEntity.MU_DYNAMIC);
	self.model[count]:SetLocalPosition(mathfunction.vector3(modelconfig.lower_teeth.pos[1],modelconfig.lower_teeth.pos[2],modelconfig.lower_teeth.pos[3]));
    self.model_face:AttachNode(self.model[count]);
	self.lowerteeth_trans_left = modelconfig.lower_teeth.trans_jaw_left.weight;
	self.lowerteeth_trans_right = modelconfig.lower_teeth.trans_jaw_left.weight;
	self.lowerteeth_trans_forward = modelconfig.lower_teeth.trans_jaw_forward.weight;
	self.lowerteeth_rot = modelconfig.lower_teeth.rot_angle.weight;
	self.bsmodel["lower_teeth"] = count;
	--tongue
	count = count + 1;
	self.model[count] = apollonode.MeshNode();
	self.model[count]:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,modelconfig.eyes.right.texture);
    self.model[count].render:SetKeepSource(true);
    self.model[count]:SetShow(true);
    self.model[count]:CreateResource(modelconfig.tongue.mesh,render,Nil,Nil,Nil,Nil,apolloengine.VertexBufferEntity.MU_DYNAMIC);
	self.model[count]:SetLocalPosition(mathfunction.vector3(modelconfig.tongue.pos[1],modelconfig.tongue.pos[2],modelconfig.tongue.pos[3]));
	self.model_face:AttachNode(self.model[count]);
	self.tongue_trans_left = modelconfig.tongue.trans_jaw_left.weight;
	self.tongue_trans_right = modelconfig.tongue.trans_jaw_left.weight;
	self.tongue_trans_forward = modelconfig.tongue.trans_jaw_forward.weight;
	self.tongue_rot = modelconfig.tongue.rot_angle.weight;
	self.bsmodel["tongue"] = count;
	
	--stationary	
	for meshKey, meshitems in pairs(modelconfig.stationary) do
		count = count + 1;
		self.model[count] = apollonode.MeshNode();
		self.model[count]:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,meshitems.texture);
		self.model[count].render:SetKeepSource(true);
		self.model[count]:CreateResource(meshitems.mesh,render,Nil,Nil,Nil,Nil,apolloengine.VertexBufferEntity.MU_DYNAMIC);
		self.model[count]:SetShow(true);
		self.model_face:AttachNode(self.model[count]);
		self.model[count]:SetLocalPosition(mathfunction.vector3(meshitems.pos[1],meshitems.pos[2],meshitems.pos[3]));
		self.bsmodel[meshitems.name] = count;
	end
	
	if self.bsmodel["lower_teeth"] ~= nil then
		self.trans_lowteeth = venusblendshape.model[self.bsmodel["lower_teeth"]]:GetLocalPosition();
	end
	if self.bsmodel["tongue"] ~= nil then
		self.trans_tongue = venusblendshape.model[self.bsmodel["tongue"]]:GetLocalPosition();
	end
	self.weights = {};
end

return venusblendshape;