local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local defined = require "superme3d.defined"
local beholder = require "superme3d.observer"
local utility = require "superme3d.utility"
local skeleton = require "superme3d.model.skeletonnode"
local venusjson = require "venusjson"

local Object = require "classic"

--虚拟节点，不包含可渲染的组件
local Bulletnode = Object:extend();

function Bulletnode:new()
	Bulletnode.super.new(self);
	
end

function Bulletnode:Initialize(path, mesh,skenode)
	self.rigidbody = {};
	self.anchorjonit = {};
	local config = venusjson.LaodJsonFile(path);
  	mesh:SetShow(false);
	self.vertex = mesh:GetVertexStream();
  
	self.softnode = mesh.node;
	self.soft = mesh:CreateComponent(apolloengine.Node.CT_SOFT_BODY);
	self.soft.CollisionGroup = config.collision.group;
	self.soft.CollisionMask = config.collision.mask;
  
    rigidbody = mesh:CreateComponent(apolloengine.Node.CT_SHAPECOLLIDER);
    rigidbody:CreateMeshCollisionShape(self.vertex, mesh:GetIndexStream());
    self.meshshape = rigidbody:GetCollisionShape();
	local parameter = config.param;
	self.soft:Initialize(self.meshshape ,parameter.mass);
	self:Setbulletparam(parameter);
  
  
	self.inverskin =  mesh:CreateComponent(apolloengine.Node.CT_WAHBASINVSKIN);--   apolloengine.WahbasInverseSkinComponent();
	self.skeleton = skenode;
	local inverseconfig = config.inverse;
	apolloengine.IPhysicSystem:SetGravity(mathfunction.vector3(0,0,0));
	apolloengine.IPhysicSystem:Update(0.01,10,1.0/60.0);
	self.soft:SetVertexDataToVertexStream(self.vertex);
	self:InitBoneAndVertexBind(self.vertex, inverseconfig);
	apolloengine.IPhysicSystem:SetGravity(mathfunction.vector3(0,-10,0));
	local anchorconfig = config.anchor;
	self:Setanchor(anchorconfig);

	--self.soft:EnableDebug();
end

function Bulletnode:Setbulletparam(config)
	if config.Magin ~= nil then
		self.soft:SetMagin(config.Magin);
	end
	if config.kDF ~= nil then
		self.soft:SetSoftkDF(config.kDF);
	end
	if config.KCH ~= nil then
		self.soft:SetKineticContactHardness(config.KCH);
	end
	if config.Piterations ~= nil then
		self.soft:SetSoftPiterations(config.Piterations);
	end
	if config.Stiffness ~= nil then
		self.soft:SetLinearStiffness(config.Stiffness);
	end
	if config.Clusters ~= nil then
		self.soft:GenerateClusters(config.Clusters);
	end
	if config.Debug ~= nil then
		self.soft:EnableDebug();
	end
	
	if config.PoseMatch ~= nil then
    	self.soft:SetMatch(false,true);
		self.soft:SetPoseMatch(config.PoseMatch);
	end

	if config.VolumeMatch ~= nil then
    	self.soft:SetMatch(true,false);
		self.soft:SetVolumeConversation(config.VolumeMatch);
	end
  	self.soft:RandomizeConstraints();
end

function Bulletnode:InitBoneAndVertexBind(vertexstream, config)
	
	local postions = vertexstream:GetVertexData();
	local xnormals = vertexstream:GetNormalData();
	local znormals = config.znormal;
	local adjinfos = config.adjinfo;
	self.inverskin:SetVertexData(postions,xnormals,znormals,adjinfos);
	local inversparam = config.bind;
	for key,value in pairs(inversparam) do
		local idx = self.skeleton.skeleton:GetJointIndexByID(tonumber(key));
    	local joint = self.skeleton.skeleton:GetJointByIndex(idx);
   		if joint == nil then
      		LOG("ERROR,DIDN'T FIND JOINT "..key);
    	end
		self.inverskin:AddIndexSkeletonPair(value, joint);
		--[[
		local testnode = apolloengine.Node();

		local transr = testnode:CreateComponent(apolloengine.Node.CT_TRANSFORM);
		joint:AttachNode(testnode);
		transr:SetLocalScale(mathfunction.vector3(3,3,3));
		transr:SetLocalPosition(mathfunction.vector3(0,0,0));
		local render = testnode:CreateComponent(apolloengine.Node.CT_RENDER);
		render:PushMetadata(apolloengine.RenderObjectMaterialMetadata(apolloengine.PathMetadata("comm:documents/material/lightingonly.material")));  
		render:PushMetadata(apolloengine.RenderObjectMeshFileMetadate("comm:documents/model/cube.mesh"));  
		render:CreateResource();
		if self.testnodes==nil then
			self.testnodes = {};
		end
		table.insert(	self.testnodes,testnode);]]
	end
end

function Bulletnode:Setanchor(config)
	for name, param in pairs(config) do
		local joint = self.skeleton.skeleton:GetHostNode():GetNodeByName(name);
		local rigid = joint:CreateComponent(apolloengine.Node.CT_RIGID_BODY);
		rigid:SetCollisionShape(apolloengine.RigidBodyComponent.CST_BOX);
		local shape = rigid:GetCollisionShape();
		shape.BoxHalfEtent = mathfunction.vector3(0.5, 0.5, 0.5);
		rigid:SetKinematic();
		rigid:DisableCollision();
		table.insert(self.rigidbody, rigid);
		
		table.insert(self.anchorjonit, joint);
		rigid:CleanMotion();
		for index, strength in pairs(param) do
			self.soft:AppendAnchor(index,rigid,true,strength);
		end	
	end
end

function Bulletnode:update()
  	self.soft:SetVertexDataToVertexStream(self.vertex);
  	self.inverskin:InverseSkin(self.vertex);
end

function Bulletnode:GetSoftBody()
	return self.soft;
end



return Bulletnode;


